/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.statements;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.WhitespaceInfo;
import org.openzen.zenscript.codemodel.scope.StatementScope;
import org.openzen.zenscript.codemodel.statement.ContinueStatement;
import org.openzen.zenscript.codemodel.statement.InvalidStatement;
import org.openzen.zenscript.codemodel.statement.LoopStatement;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.parser.ParsedAnnotation;
import org.openzen.zenscript.parser.statements.ParsedStatement;

public class ParsedStatementContinue
extends ParsedStatement {
    public final String name;

    public ParsedStatementContinue(CodePosition position, ParsedAnnotation[] annotations, WhitespaceInfo whitespace, String name) {
        super(position, annotations, whitespace);
        this.name = name;
    }

    @Override
    public Statement compile(StatementScope scope) {
        LoopStatement target = scope.getLoop(this.name);
        if (target == null) {
            return new InvalidStatement(this.position, CompileExceptionCode.CONTINUE_OUTSIDE_LOOP, this.name == null ? "Not in a loop" : "No such loop: " + this.name);
        }
        return this.result(new ContinueStatement(this.position, target), scope);
    }
}

