/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.shader_overrides;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;

public class IrisChunkProgram
extends ChunkProgram {
    private final int uModelViewMatrix = this.getUniformLocation("u_ModelViewMatrix");
    private final int uNormalMatrix = this.getUniformLocation("u_NormalMatrix");
    @Nullable
    private final ProgramUniforms irisProgramUniforms;
    @Nullable
    private final ProgramSamplers irisProgramSamplers;
    @Nullable
    private final ProgramImages irisProgramImages;

    public IrisChunkProgram(RenderDevice owner, ResourceLocation name, int handle, @Nullable ProgramUniforms irisProgramUniforms, @Nullable ProgramSamplers irisProgramSamplers, @Nullable ProgramImages irisProgramImages) {
        super(owner, name, handle, ChunkShaderFogComponent.None::new);
        this.irisProgramUniforms = irisProgramUniforms;
        this.irisProgramSamplers = irisProgramSamplers;
        this.irisProgramImages = irisProgramImages;
    }

    public void setup(MatrixStack poseStack, float modelScale, float textureScale) {
        super.setup(poseStack, modelScale, textureScale);
        if (this.irisProgramUniforms != null) {
            this.irisProgramUniforms.update();
        }
        if (this.irisProgramSamplers != null) {
            this.irisProgramSamplers.update();
        }
        if (this.irisProgramImages != null) {
            this.irisProgramImages.update();
        }
        Matrix4f modelViewMatrix = poseStack.func_227866_c_().func_227870_a_();
        Matrix4f normalMatrix = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
        normalMatrix.func_226600_c_();
        normalMatrix.func_226602_e_();
        this.uniformMatrix(this.uModelViewMatrix, modelViewMatrix);
        this.uniformMatrix(this.uNormalMatrix, normalMatrix);
    }

    public int getUniformLocation(String name) {
        if ("u_BlockTex".equals(name) || "u_LightTex".equals(name)) {
            return -1;
        }
        try {
            return super.getUniformLocation(name);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    private void uniformMatrix(int location, Matrix4f matrix) {
        if (location == -1) {
            return;
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            FloatBuffer buffer = memoryStack.mallocFloat(16);
            matrix.func_195879_b(buffer);
            IrisRenderSystem.uniformMatrix4fv(location, false, buffer);
        }
    }
}

