/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexUtil;
import net.coderbot.iris.block_rendering.MaterialIdHolder;
import net.coderbot.iris.compat.sodium.impl.block_id.MaterialIdAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.NormalHelper;
import org.lwjgl.system.MemoryUtil;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
MaterialIdAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private MaterialIdHolder idHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    public void writeQuad(float x, float y, float z, int color, float u, float v, int light) {
        this.uSum += u;
        this.vSum += v;
        short materialId = this.idHolder.id;
        short renderType = this.idHolder.renderType;
        this.writeQuadInternal(ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)x), ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)y), ModelVertexUtil.denormalizeVertexPositionFloatAsShort((float)z), color, ModelVertexUtil.denormalizeVertexTextureFloatAsShort((float)u), ModelVertexUtil.denormalizeVertexTextureFloatAsShort((float)v), ModelVertexUtil.encodeLightMapTexCoord((int)light), materialId, renderType);
    }

    private void writeQuadInternal(short x, short y, short z, int color, short u, short v, int light, short materialId, short renderType) {
        long i = this.writePointer;
        ++this.vertexCount;
        MemoryUtil.memPutShort((long)i, (short)x);
        MemoryUtil.memPutShort((long)(i + 2L), (short)y);
        MemoryUtil.memPutShort((long)(i + 4L), (short)z);
        MemoryUtil.memPutInt((long)(i + 8L), (int)color);
        MemoryUtil.memPutShort((long)(i + 12L), (short)u);
        MemoryUtil.memPutShort((long)(i + 14L), (short)v);
        MemoryUtil.memPutInt((long)(i + 16L), (int)light);
        MemoryUtil.memPutShort((long)(i + 36L), (short)materialId);
        MemoryUtil.memPutShort((long)(i + 38L), (short)renderType);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            MemoryUtil.memPutFloat((long)(i + 20L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 20L - 40L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 20L - 80L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 20L - 120L), (float)this.uSum);
            MemoryUtil.memPutFloat((long)(i + 24L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(i + 24L - 40L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(i + 24L - 80L), (float)this.vSum);
            MemoryUtil.memPutFloat((long)(i + 24L - 120L), (float)this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(i, 40);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            MemoryUtil.memPutInt((long)(i + 32L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 32L - 40L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 32L - 80L), (int)packedNormal);
            MemoryUtil.memPutInt((long)(i + 32L - 120L), (int)packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            MemoryUtil.memPutInt((long)(i + 28L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 28L - 40L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 28L - 80L), (int)tangent);
            MemoryUtil.memPutInt((long)(i + 28L - 120L), (int)tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setIdHolder(MaterialIdHolder holder) {
        this.idHolder = holder;
    }
}

