/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.EXTShaderImageLoadStore;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL42C;

public class IrisRenderSystem {
    public static void getIntegerv(int pname, int[] params) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glGetIntegerv((int)pname, (int[])params);
    }

    public static void getFloatv(int pname, float[] params) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glGetFloatv((int)pname, (float[])params);
    }

    public static void generateMipmaps(int mipmapTarget) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glGenerateMipmap((int)mipmapTarget);
    }

    public static void bindAttributeLocation(int program, int index, CharSequence name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public static void texImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)pixels);
    }

    public static void uniformMatrix4fv(int location, boolean transpose, FloatBuffer matrix) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)matrix);
    }

    public static void copyTexImage2D(int target, int level, int internalFormat, int x, int y, int width, int height, int border) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glCopyTexImage2D((int)target, (int)level, (int)internalFormat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public static void uniform1f(int location, float v0) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform1f((int)location, (float)v0);
    }

    public static void uniform1i(int location, int v0) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform1i((int)location, (int)v0);
    }

    public static void uniform2f(int location, float v0, float v1) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform2f((int)location, (float)v0, (float)v1);
    }

    public static void uniform2i(int location, int v0, int v1) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform2i((int)location, (int)v0, (int)v1);
    }

    public static void uniform3f(int location, float v0, float v1, float v2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    public static void uniform4f(int location, float v0, float v1, float v2, float v3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void uniform4i(int location, int v0, int v1, int v2, int v3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glUniform4i((int)location, (int)v0, (int)v1, (int)v2, (int)v3);
    }

    public static int getAttribLocation(int programId, String name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetAttribLocation((int)programId, (CharSequence)name);
    }

    public static int getUniformLocation(int programId, String name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetUniformLocation((int)programId, (CharSequence)name);
    }

    public static void texParameteriv(int target, int pname, int[] params) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11C.glTexParameteriv((int)target, (int)pname, (int[])params);
    }

    public static String getProgramInfoLog(int program) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetProgramInfoLog((int)program);
    }

    public static String getShaderInfoLog(int shader) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetShaderInfoLog((int)shader);
    }

    public static void drawBuffers(int[] buffers) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glDrawBuffers((int[])buffers);
    }

    public static void readBuffer(int buffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glReadBuffer((int)buffer);
    }

    public static String getActiveUniform(int program, int index, int size, IntBuffer type, IntBuffer name) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetActiveUniform((int)program, (int)index, (int)size, (IntBuffer)type, (IntBuffer)name);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void bufferData(int target, float[] data, int usage) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glBufferData((int)target, (float[])data, (int)usage);
    }

    public static void vertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glVertexAttrib4f((int)index, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public static void detachShader(int program, int shader) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30C.glDetachShader((int)program, (int)shader);
    }

    public static int getTexParameteri(int target, int pname) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30C.glGetTexParameteri((int)target, (int)pname);
    }

    public static void bindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (GL.getCapabilities().OpenGL42) {
            GL42C.glBindImageTexture((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        } else {
            EXTShaderImageLoadStore.glBindImageTextureEXT((int)unit, (int)texture, (int)level, (boolean)layered, (int)layer, (int)access, (int)format);
        }
    }

    public static int getMaxImageUnits() {
        if (GL.getCapabilities().OpenGL42) {
            return GlStateManager.func_227612_D_((int)36664);
        }
        if (GL.getCapabilities().GL_EXT_shader_image_load_store) {
            return GlStateManager.func_227612_D_((int)36664);
        }
        return 0;
    }

    @Deprecated
    public static void setupProjectionMatrix(float[] matrix) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        GL20.glLoadMatrixf((float[])matrix);
        RenderSystem.matrixMode((int)5888);
    }

    @Deprecated
    public static void restoreProjectionMatrix() {
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    }
}

