/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import java.util.Optional;

public enum AlphaTestFunction {
    NEVER(512),
    LESS(513),
    EQUAL(514),
    LEQUAL(515),
    GREATER(516),
    NOTEQUAL(517),
    GEQUAL(518),
    ALWAYS(519);

    private final int glId;

    private AlphaTestFunction(int glFormat) {
        this.glId = glFormat;
    }

    public static Optional<AlphaTestFunction> fromGlId(int glId) {
        switch (glId) {
            case 512: {
                return Optional.of(NEVER);
            }
            case 513: {
                return Optional.of(LESS);
            }
            case 514: {
                return Optional.of(EQUAL);
            }
            case 515: {
                return Optional.of(LEQUAL);
            }
            case 516: {
                return Optional.of(GREATER);
            }
            case 517: {
                return Optional.of(NOTEQUAL);
            }
            case 518: {
                return Optional.of(GEQUAL);
            }
            case 519: {
                return Optional.of(ALWAYS);
            }
        }
        return Optional.empty();
    }

    public static Optional<AlphaTestFunction> fromString(String name) {
        if ("GL_ALWAYS".equals(name)) {
            return Optional.of(ALWAYS);
        }
        try {
            return Optional.of(AlphaTestFunction.valueOf(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public int getGlId() {
        return this.glId;
    }
}

