/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.vertices;

import com.mojang.blaze3d.vertex.IVertexConsumer;
import java.nio.ByteBuffer;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import net.coderbot.iris.vertices.BufferBuilderPolygonView;
import net.coderbot.iris.vertices.ExtendingBufferBuilder;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormalHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
implements IVertexConsumer,
BlockSensitiveBufferBuilder,
ExtendingBufferBuilder {
    @Unique
    private boolean extending;
    @Unique
    private int vertexCount;
    @Unique
    private final BufferBuilderPolygonView polygon = new BufferBuilderPolygonView();
    @Unique
    private final Vector3f normal = new Vector3f();
    @Unique
    private boolean injectNormal;
    @Unique
    private short currentBlock;
    @Unique
    private short currentRenderType;
    @Shadow
    private boolean field_227826_s_;
    @Shadow
    private boolean field_227827_t_;
    @Shadow
    private ByteBuffer field_179001_a;
    @Shadow
    private int field_179006_k;
    @Shadow
    private VertexFormat field_179011_q;
    @Shadow
    private int field_227824_l_;
    @Shadow
    @Nullable
    private VertexFormatElement field_181677_f;
    @Unique
    private boolean iris$shouldNotExtend = false;

    @Shadow
    public abstract void func_181668_a(int var1, VertexFormat var2);

    @Shadow
    public abstract void func_225591_a_(int var1, short var2);

    @Shadow
    protected abstract void func_181670_b(int var1);

    @Override
    public void iris$beginWithoutExtending(int drawMode, VertexFormat vertexFormat) {
        this.iris$shouldNotExtend = true;
        this.func_181668_a(drawMode, vertexFormat);
        this.iris$shouldNotExtend = false;
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")})
    private void iris$onBegin(int drawMode, VertexFormat format, CallbackInfo ci) {
        boolean shouldExtend = !this.iris$shouldNotExtend && BlockRenderingSettings.INSTANCE.shouldUseExtendedVertexFormat();
        this.extending = shouldExtend && (format == DefaultVertexFormats.field_176600_a || format == DefaultVertexFormats.field_227849_i_ || format == DefaultVertexFormats.field_227852_q_);
        this.vertexCount = 0;
        if (this.extending) {
            this.injectNormal = format == DefaultVertexFormats.field_227852_q_;
        }
    }

    @Inject(method={"begin"}, at={@At(value="RETURN")})
    private void iris$afterBegin(int drawMode, VertexFormat format, CallbackInfo ci) {
        if (this.extending) {
            this.field_179011_q = format == DefaultVertexFormats.field_227849_i_ ? IrisVertexFormats.ENTITY : IrisVertexFormats.TERRAIN;
            this.field_181677_f = (VertexFormatElement)this.field_179011_q.func_227894_c_().get(0);
        }
    }

    @Inject(method={"discard"}, at={@At(value="HEAD")})
    private void iris$onReset(CallbackInfo ci) {
        this.extending = false;
        this.vertexCount = 0;
    }

    @Inject(method={"switchFormat"}, at={@At(value="RETURN")})
    private void iris$preventHardcodedVertexWriting(VertexFormat format, CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        this.field_227826_s_ = false;
        this.field_227827_t_ = false;
    }

    @Inject(method={"endVertex"}, at={@At(value="HEAD")})
    private void iris$beforeNext(CallbackInfo ci) {
        if (!this.extending) {
            return;
        }
        if (this.injectNormal && this.field_181677_f == DefaultVertexFormats.field_181717_q) {
            this.putInt(0, 0);
            this.func_181667_k();
        }
        this.func_181670_b(15);
        this.func_225591_a_(0, this.currentBlock);
        this.func_225591_a_(2, this.currentRenderType);
        this.func_181667_k();
        this.func_225590_a_(0, 0.0f);
        this.func_225590_a_(4, 0.0f);
        this.func_181667_k();
        this.putInt(0, 0);
        this.func_181667_k();
        ++this.vertexCount;
        if (this.field_179006_k == 7 && this.vertexCount == 4 || this.field_179006_k == 4 && this.vertexCount == 3) {
            this.fillExtendedData(this.vertexCount);
        }
    }

    @Override
    public void beginBlock(short block, short renderType) {
        this.currentBlock = block;
        this.currentRenderType = renderType;
    }

    @Override
    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
    }

    @Unique
    private void fillExtendedData(int vertexAmount) {
        this.vertexCount = 0;
        int extendedDataLength = 16;
        int stride = this.field_179011_q.func_177338_f();
        this.polygon.setup(this.field_179001_a, this.field_227824_l_, stride, vertexAmount);
        float midU = 0.0f;
        float midV = 0.0f;
        for (int vertex = 0; vertex < vertexAmount; ++vertex) {
            midU += this.polygon.u(vertex);
            midV += this.polygon.v(vertex);
        }
        midU /= (float)vertexAmount;
        midV /= (float)vertexAmount;
        if (vertexAmount == 3) {
            NormalHelper.computeFaceNormalTri(this.normal, this.polygon);
        } else {
            NormalHelper.computeFaceNormal(this.normal, this.polygon);
        }
        int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
        int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.polygon);
        for (int vertex = 0; vertex < vertexAmount; ++vertex) {
            this.field_179001_a.putFloat(this.field_227824_l_ - 12 - stride * vertex, midU);
            this.field_179001_a.putFloat(this.field_227824_l_ - 8 - stride * vertex, midV);
            this.field_179001_a.putInt(this.field_227824_l_ - 4 - extendedDataLength - stride * vertex, packedNormal);
            this.field_179001_a.putInt(this.field_227824_l_ - 4 - stride * vertex, tangent);
        }
    }

    @Unique
    private void putInt(int i, int value) {
        this.field_179001_a.putInt(this.field_227824_l_ + i, value);
    }
}

