/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.vendored.joml.Vector4f;

public class ClearPassCreator {
    public static ImmutableList<ClearPass> createClearPasses(RenderTargets renderTargets, boolean fullClear, PackRenderTargetDirectives renderTargetDirectives) {
        int maxDrawBuffers = GlStateManager.func_227612_D_((int)34852);
        HashMap<Vector4f, IntList> clearByColor = new HashMap<Vector4f, IntList>();
        renderTargetDirectives.getRenderTargetSettings().forEach((bufferI, settings) -> {
            int buffer = bufferI;
            if (fullClear || settings.shouldClear()) {
                Vector4f defaultClearColor = buffer == 0 ? null : (buffer == 1 ? new Vector4f(1.0f, 1.0f, 1.0f, 1.0f) : new Vector4f(0.0f, 0.0f, 0.0f, 0.0f));
                Vector4f clearColor = settings.getClearColor().orElse(defaultClearColor);
                clearByColor.computeIfAbsent(clearColor, color -> new IntArrayList()).add(buffer);
            }
        });
        ArrayList clearPasses = new ArrayList();
        clearByColor.forEach((clearColor, buffers) -> {
            int startIndex = 0;
            while (startIndex < buffers.size()) {
                int[] clearBuffers = new int[Math.min(buffers.size() - startIndex, maxDrawBuffers)];
                for (int i = 0; i < clearBuffers.length; ++i) {
                    clearBuffers[i] = buffers.getInt(startIndex);
                    ++startIndex;
                }
                clearPasses.add(new ClearPass((Vector4f)clearColor, renderTargets.createFramebufferWritingToAlt(clearBuffers)));
                clearPasses.add(new ClearPass((Vector4f)clearColor, renderTargets.createFramebufferWritingToMain(clearBuffers)));
            }
        });
        return ImmutableList.copyOf(clearPasses);
    }
}

