/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.coderbot.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.coderbot.iris.mixin.GameRendererAccessor;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.GameType;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    private boolean ACTIVE;
    private boolean renderingSolid;
    private final FullyBufferedMultiBufferSource bufferSource = new FullyBufferedMultiBufferSource();
    public static final float DEPTH = 0.125f;

    private void setupGlState(GameRenderer gameRenderer, ActiveRenderInfo camera, MatrixStack poseStack, float tickDelta) {
        MatrixStack.Entry pose = poseStack.func_227866_c_();
        Matrix4f scaleMatrix = Matrix4f.func_226593_a_((float)1.0f, (float)1.0f, (float)0.125f);
        scaleMatrix.func_226595_a_(gameRenderer.func_228382_a_(camera, tickDelta, false));
        gameRenderer.func_228379_a_(scaleMatrix);
        pose.func_227870_a_().func_226591_a_();
        pose.func_227872_b_().func_226119_c_();
        ((GameRendererAccessor)gameRenderer).invokeBobHurt(poseStack, tickDelta);
        if (Minecraft.func_71410_x().field_71474_y.field_74336_f) {
            ((GameRendererAccessor)gameRenderer).invokeBobView(poseStack, tickDelta);
        }
    }

    private boolean canRender(ActiveRenderInfo camera, GameRenderer gameRenderer) {
        return ((GameRendererAccessor)gameRenderer).getRenderHand() && !camera.func_216770_i() && camera.func_216773_g() instanceof PlayerEntity && !((GameRendererAccessor)gameRenderer).getPanoramicMode() && !Minecraft.func_71410_x().field_71474_y.field_74319_N && (!(camera.func_216773_g() instanceof LivingEntity) || !((LivingEntity)camera.func_216773_g()).func_70608_bn()) && Minecraft.func_71410_x().field_71442_b.func_178889_l() != GameType.SPECTATOR;
    }

    public boolean isHandTranslucent(Hand hand) {
        Item item = Minecraft.func_71410_x().field_71439_g.func_184582_a(hand == Hand.OFF_HAND ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND).func_77973_b();
        if (item instanceof BlockItem) {
            return RenderTypeLookup.func_228390_a_((BlockState)((BlockItem)item).func_179223_d().func_176223_P()) == RenderType.func_228645_f_();
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(Hand.MAIN_HAND) || this.isHandTranslucent(Hand.OFF_HAND);
    }

    public void renderSolid(MatrixStack poseStack, float tickDelta, ActiveRenderInfo camera, GameRenderer gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !IrisApi.getInstance().isShaderPackInUse()) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        poseStack.func_227860_a_();
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("iris_hand");
        this.setupGlState(gameRenderer, camera, poseStack, tickDelta);
        this.renderingSolid = true;
        Minecraft.func_71410_x().func_175597_ag().func_228396_a_(tickDelta, poseStack, (IRenderTypeBuffer.Impl)this.bufferSource, Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().func_175598_ae().func_229085_a_(camera.func_216773_g(), tickDelta));
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        gameRenderer.func_228379_a_(CapturedRenderingState.INSTANCE.getGbufferProjection());
        poseStack.func_227865_b_();
        this.bufferSource.func_228461_a_();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(MatrixStack poseStack, float tickDelta, ActiveRenderInfo camera, GameRenderer gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && IrisApi.getInstance().isShaderPackInUse())) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        poseStack.func_227860_a_();
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("iris_hand_translucent");
        this.setupGlState(gameRenderer, camera, poseStack, tickDelta);
        Minecraft.func_71410_x().func_175597_ag().func_228396_a_(tickDelta, poseStack, (IRenderTypeBuffer.Impl)this.bufferSource, Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().func_175598_ae().func_229085_a_(camera.func_216773_g(), tickDelta));
        poseStack.func_227865_b_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        gameRenderer.func_228379_a_(CapturedRenderingState.INSTANCE.getGbufferProjection());
        this.bufferSource.func_228461_a_();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }

    public FullyBufferedMultiBufferSource getBufferSource() {
        return this.bufferSource;
    }
}

