/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.coderbot.batchedentityrendering.impl.BatchingDebugMessageHelper;
import net.coderbot.batchedentityrendering.impl.DrawCallTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.RenderBuffersExt;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.shadows.CullingDataCache;
import net.coderbot.iris.shadows.Matrix4fAccess;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.CullEverythingFrustum;
import net.coderbot.iris.shadows.frustum.FrustumHolder;
import net.coderbot.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class ShadowRenderer {
    public static Matrix4f MODELVIEW;
    public static Matrix4f PROJECTION;
    public static List<TileEntity> visibleBlockEntities;
    public static boolean ACTIVE;
    private final float halfPlaneLength;
    private final float renderDistanceMultiplier;
    private final float entityShadowDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    private final Float fov;
    private final ShadowRenderTargets targets;
    private final OptionalBoolean packCullingState;
    private final boolean packHasVoxelization;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final float sunPathRotation;
    private final RenderTypeBuffers buffers;
    private final RenderBuffersExt renderBuffersExt;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final String debugStringOverall;
    private FrustumHolder terrainFrustumHolder;
    private FrustumHolder entityFrustumHolder;
    private String debugStringTerrain = "(unavailable)";
    private int renderedShadowEntities = 0;
    private int renderedShadowBlockEntities = 0;
    private IProfiler profiler = Minecraft.func_71410_x().func_213239_aq();

    public ShadowRenderer(ProgramSource shadow, PackDirectives directives, ShadowRenderTargets shadowRenderTargets, boolean shadowUsesImages) {
        PackShadowDirectives shadowDirectives = directives.getShadowDirectives();
        this.halfPlaneLength = shadowDirectives.getDistance();
        this.renderDistanceMultiplier = shadowDirectives.getDistanceRenderMul();
        this.entityShadowDistanceMultiplier = shadowDirectives.getEntityShadowDistanceMul();
        this.resolution = shadowDirectives.getResolution();
        this.intervalSize = shadowDirectives.getIntervalSize();
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain();
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent();
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities();
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer();
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities();
        this.debugStringOverall = "half plane = " + this.halfPlaneLength + " meters @ " + this.resolution + "x" + this.resolution;
        this.terrainFrustumHolder = new FrustumHolder();
        this.entityFrustumHolder = new FrustumHolder();
        this.fov = shadowDirectives.getFov();
        this.targets = shadowRenderTargets;
        if (shadow != null) {
            this.packHasVoxelization = shadow.getGeometrySource().isPresent() || shadowUsesImages;
            this.packCullingState = shadowDirectives.getCullingState();
        } else {
            this.packHasVoxelization = false;
            this.packCullingState = OptionalBoolean.DEFAULT;
        }
        this.sunPathRotation = directives.getSunPathRotation();
        this.buffers = new RenderTypeBuffers();
        this.renderBuffersExt = this.buffers instanceof RenderBuffersExt ? (RenderBuffersExt)this.buffers : null;
        this.configureSamplingSettings(shadowDirectives);
    }

    public static MatrixStack createShadowModelView(float sunPathRotation, float intervalSize) {
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x;
        double cameraY = cameraPos.y;
        double cameraZ = cameraPos.z;
        MatrixStack modelView = new MatrixStack();
        ShadowMatrices.createModelViewMatrix(modelView.func_227866_c_().func_227870_a_(), ShadowRenderer.getShadowAngle(), intervalSize, sunPathRotation, cameraX, cameraY, cameraZ);
        return modelView;
    }

    private static ClientWorld getLevel() {
        return Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
    }

    private static float getSkyAngle() {
        return ShadowRenderer.getLevel().func_242415_f(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static float getSunAngle() {
        float skyAngle = ShadowRenderer.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = ShadowRenderer.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private void configureSamplingSettings(PackShadowDirectives shadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> depthSamplingSettings = shadowDirectives.getDepthSamplingSettings();
        ImmutableList<PackShadowDirectives.SamplingSettings> colorSamplingSettings = shadowDirectives.getColorSamplingSettings();
        RenderSystem.activeTexture((int)33988);
        RenderSystem.bindTexture((int)this.targets.getDepthTexture().getTextureId());
        this.configureDepthSampler(this.targets.getDepthTexture().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(0));
        RenderSystem.bindTexture((int)this.targets.getDepthTextureNoTranslucents().getTextureId());
        this.configureDepthSampler(this.targets.getDepthTextureNoTranslucents().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(1));
        for (int i = 0; i < colorSamplingSettings.size(); ++i) {
            int glTextureId = this.targets.getColorTextureId(i);
            RenderSystem.bindTexture((int)glTextureId);
            this.configureSampler(glTextureId, (PackShadowDirectives.SamplingSettings)colorSamplingSettings.get(i));
        }
        RenderSystem.bindTexture((int)0);
        RenderSystem.activeTexture((int)33984);
    }

    private void configureDepthSampler(int glTextureId, PackShadowDirectives.DepthSamplingSettings settings) {
        if (settings.getHardwareFiltering()) {
            RenderSystem.texParameter((int)3553, (int)34892, (int)34894);
        }
        IrisRenderSystem.texParameteriv(3553, 36422, new int[]{6403, 6403, 6403, 1});
        this.configureSampler(glTextureId, settings);
    }

    private void configureSampler(int glTextureId, PackShadowDirectives.SamplingSettings settings) {
        if (settings.getMipmap()) {
            int filteringMode = settings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(glTextureId, filteringMode));
        }
        if (!settings.getNearest()) {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        } else {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        }
    }

    private void generateMipmaps() {
        RenderSystem.activeTexture((int)33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            RenderSystem.bindTexture((int)mipmapPass.getTexture());
            this.setupMipmappingForBoundTexture(mipmapPass.getTargetFilteringMode());
        }
        RenderSystem.bindTexture((int)0);
        RenderSystem.activeTexture((int)33984);
    }

    private void setupMipmappingForBoundTexture(int filteringMode) {
        IrisRenderSystem.generateMipmaps(3553);
        RenderSystem.texParameter((int)3553, (int)10241, (int)filteringMode);
    }

    private FrustumHolder createShadowFrustum(float renderMultiplier, FrustumHolder holder) {
        String reason;
        double distance;
        if ((this.packCullingState == OptionalBoolean.FALSE || this.packHasVoxelization) && this.packCullingState != OptionalBoolean.TRUE) {
            distance = this.halfPlaneLength * renderMultiplier;
            reason = this.packCullingState == OptionalBoolean.FALSE ? "(set by shader pack)" : "(voxelization detected)";
            if (distance <= 0.0 || distance > (double)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16)) {
                String distanceInfo = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 + " blocks (capped by normal render distance)";
                String cullingInfo = "disabled " + reason;
                return holder.setInfo(new NonCullingFrustum(), distanceInfo, cullingInfo);
            }
        } else {
            String cullingInfo;
            BoxCuller boxCuller;
            String distanceInfo;
            double distance2 = this.halfPlaneLength * renderMultiplier;
            String setter = "(set by shader pack)";
            if (renderMultiplier < 0.0f) {
                distance2 = IrisVideoSettings.shadowDistance * 16;
                setter = "(set by user)";
            }
            if (distance2 >= (double)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16)) {
                distanceInfo = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 + " blocks (capped by normal render distance)";
                boxCuller = null;
            } else {
                distanceInfo = distance2 + " blocks " + setter;
                if (distance2 == 0.0) {
                    cullingInfo = "no shadows rendered";
                    holder.setInfo(new CullEverythingFrustum(), distanceInfo, cullingInfo);
                }
                boxCuller = new BoxCuller(distance2);
            }
            cullingInfo = "Advanced Frustum Culling enabled";
            Vector4f shadowLightPosition = new CelestialUniforms(this.sunPathRotation).getShadowLightPositionInWorldSpace();
            Vector3f shadowLightVectorFromOrigin = new Vector3f(shadowLightPosition.x(), shadowLightPosition.y(), shadowLightPosition.z());
            shadowLightVectorFromOrigin.func_229194_d_();
            return holder.setInfo(new AdvancedShadowCullingFrustum(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), shadowLightVectorFromOrigin, boxCuller), distanceInfo, cullingInfo);
        }
        String distanceInfo = distance + " blocks (set by shader pack)";
        String cullingInfo = "distance only " + reason;
        BoxCuller boxCuller = new BoxCuller(distance);
        holder.setInfo(new BoxCullingFrustum(boxCuller), distanceInfo, cullingInfo);
        return holder;
    }

    private void setupGlState(float[] projMatrix) {
        IrisRenderSystem.setupProjectionMatrix(projMatrix);
        RenderSystem.disableCull();
    }

    private void restoreGlState() {
        RenderSystem.enableCull();
        IrisRenderSystem.restoreProjectionMatrix();
    }

    private void copyPreTranslucentDepth() {
        this.profiler.func_219895_b("translucent depth copy");
        this.targets.copyPreTranslucentDepth();
    }

    private void renderEntities(LevelRendererAccessor levelRenderer, ClippingHelper frustum, IRenderTypeBuffer.Impl bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        EntityRendererManager dispatcher = levelRenderer.getEntityRenderDispatcher();
        int shadowEntities = 0;
        this.profiler.func_76320_a("cull");
        ArrayList<Entity> renderedEntities = new ArrayList<Entity>(32);
        for (Entity entity2 : ShadowRenderer.getLevel().func_217416_b()) {
            if (!dispatcher.func_229086_a_(entity2, frustum, cameraX, cameraY, cameraZ) || entity2.func_175149_v()) continue;
            renderedEntities.add(entity2);
        }
        this.profiler.func_219895_b("sort");
        renderedEntities.sort(Comparator.comparingInt(entity -> entity.func_200600_R().hashCode()));
        this.profiler.func_219895_b("build geometry");
        for (Entity entity2 : renderedEntities) {
            levelRenderer.invokeRenderEntity(entity2, cameraX, cameraY, cameraZ, tickDelta, modelView, (IRenderTypeBuffer)bufferSource);
            ++shadowEntities;
        }
        this.renderedShadowEntities = shadowEntities;
        this.profiler.func_76319_b();
    }

    private void renderPlayerEntity(LevelRendererAccessor levelRenderer, ClippingHelper frustum, IRenderTypeBuffer.Impl bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        EntityRendererManager dispatcher = levelRenderer.getEntityRenderDispatcher();
        this.profiler.func_76320_a("cull");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!dispatcher.func_229086_a_((Entity)player, frustum, cameraX, cameraY, cameraZ) || player.func_175149_v()) {
            return;
        }
        this.profiler.func_219895_b("build geometry");
        int shadowEntities = 0;
        if (!player.func_184188_bt().isEmpty()) {
            for (int i = 0; i < player.func_184188_bt().size(); ++i) {
                levelRenderer.invokeRenderEntity((Entity)player.func_184188_bt().get(i), cameraX, cameraY, cameraZ, tickDelta, modelView, (IRenderTypeBuffer)bufferSource);
                ++shadowEntities;
            }
        }
        if (player.func_184187_bx() != null) {
            levelRenderer.invokeRenderEntity(player.func_184187_bx(), cameraX, cameraY, cameraZ, tickDelta, modelView, (IRenderTypeBuffer)bufferSource);
            ++shadowEntities;
        }
        levelRenderer.invokeRenderEntity((Entity)player, cameraX, cameraY, cameraZ, tickDelta, modelView, (IRenderTypeBuffer)bufferSource);
        this.renderedShadowEntities = ++shadowEntities;
        this.profiler.func_76319_b();
    }

    private void renderBlockEntities(IRenderTypeBuffer.Impl bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta, boolean hasEntityFrustum) {
        this.profiler.func_76320_a("build blockentities");
        int shadowBlockEntities = 0;
        BoxCuller culler = null;
        if (hasEntityFrustum) {
            culler = new BoxCuller(this.halfPlaneLength * (this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier));
            culler.setPosition(cameraX, cameraY, cameraZ);
        }
        for (TileEntity entity : visibleBlockEntities) {
            BlockPos pos = entity.func_174877_v();
            if (hasEntityFrustum && culler.isCulled(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1)) continue;
            modelView.func_227860_a_();
            modelView.func_227861_a_((double)pos.func_177958_n() - cameraX, (double)pos.func_177956_o() - cameraY, (double)pos.func_177952_p() - cameraZ);
            TileEntityRendererDispatcher.field_147556_a.func_228850_a_(entity, tickDelta, modelView, (IRenderTypeBuffer)bufferSource);
            modelView.func_227865_b_();
            ++shadowBlockEntities;
        }
        this.renderedShadowBlockEntities = shadowBlockEntities;
        this.profiler.func_76319_b();
    }

    public void renderShadows(LevelRendererAccessor levelRenderer, ActiveRenderInfo playerCamera) {
        this.profiler = Minecraft.func_71410_x().func_213239_aq();
        Minecraft client = Minecraft.func_71410_x();
        this.profiler.func_219895_b("shadows");
        ACTIVE = true;
        RenderTypeBuffers playerBuffers = levelRenderer.getRenderBuffers();
        levelRenderer.setRenderBuffers(this.buffers);
        visibleBlockEntities = new ArrayList<TileEntity>();
        MatrixStack modelView = ShadowRenderer.createShadowModelView(this.sunPathRotation, this.intervalSize);
        MODELVIEW = modelView.func_227866_c_().func_227870_a_().func_226601_d_();
        float[] projMatrix = this.fov != null ? ShadowMatrices.createPerspectiveMatrix(this.fov.floatValue()) : ShadowMatrices.createOrthoMatrix(this.halfPlaneLength);
        PROJECTION = new Matrix4f();
        ((Matrix4fAccess)PROJECTION).copyFromArray(projMatrix);
        this.profiler.func_76320_a("terrain_setup");
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRenderer)).saveState();
        }
        this.profiler.func_76320_a("initialize frustum");
        this.terrainFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier, this.terrainFrustumHolder);
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x();
        double cameraY = cameraPos.y();
        double cameraZ = cameraPos.z();
        this.terrainFrustumHolder.getFrustum().func_228952_a_(cameraX, cameraY, cameraZ);
        this.profiler.func_76319_b();
        boolean wasChunkCullingEnabled = client.field_175612_E;
        client.field_175612_E = false;
        boolean regenerateClouds = levelRenderer.shouldRegenerateClouds();
        ((WorldRenderer)levelRenderer).func_174979_m();
        levelRenderer.setShouldRegenerateClouds(regenerateClouds);
        levelRenderer.invokeSetupRender(playerCamera, this.terrainFrustumHolder.getFrustum(), false, levelRenderer.getFrameId(), false);
        levelRenderer.setFrameId(levelRenderer.getFrameId() + 1);
        client.field_175612_E = wasChunkCullingEnabled;
        this.profiler.func_219895_b("terrain");
        this.setupGlState(projMatrix);
        if (this.shouldRenderTerrain) {
            levelRenderer.invokeRenderChunkLayer(RenderType.func_228639_c_(), modelView, cameraX, cameraY, cameraZ);
            levelRenderer.invokeRenderChunkLayer(RenderType.func_228643_e_(), modelView, cameraX, cameraY, cameraZ);
            levelRenderer.invokeRenderChunkLayer(RenderType.func_228641_d_(), modelView, cameraX, cameraY, cameraZ);
        }
        this.profiler.func_219895_b("entities");
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        boolean hasEntityFrustum = false;
        if (this.entityShadowDistanceMultiplier == 1.0f || this.entityShadowDistanceMultiplier < 0.0f) {
            this.entityFrustumHolder.setInfo(this.terrainFrustumHolder.getFrustum(), this.terrainFrustumHolder.getDistanceInfo(), this.terrainFrustumHolder.getCullingInfo());
        } else {
            hasEntityFrustum = true;
            this.entityFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier, this.entityFrustumHolder);
        }
        ClippingHelper entityShadowFrustum = this.entityFrustumHolder.getFrustum();
        entityShadowFrustum.func_228952_a_(cameraX, cameraY, cameraZ);
        if (this.renderBuffersExt != null) {
            this.renderBuffersExt.beginLevelRendering();
        }
        if (this.buffers instanceof DrawCallTrackingRenderBuffers) {
            ((DrawCallTrackingRenderBuffers)this.buffers).resetDrawCounts();
        }
        IRenderTypeBuffer.Impl bufferSource = this.buffers.func_228487_b_();
        if (this.shouldRenderEntities) {
            this.renderEntities(levelRenderer, entityShadowFrustum, bufferSource, modelView, cameraX, cameraY, cameraZ, tickDelta);
        } else if (this.shouldRenderPlayer) {
            this.renderPlayerEntity(levelRenderer, entityShadowFrustum, bufferSource, modelView, cameraX, cameraY, cameraZ, tickDelta);
        }
        if (this.shouldRenderBlockEntities) {
            this.renderBlockEntities(bufferSource, modelView, cameraX, cameraY, cameraZ, tickDelta, hasEntityFrustum);
        }
        this.profiler.func_219895_b("draw entities");
        bufferSource.func_228461_a_();
        this.copyPreTranslucentDepth();
        this.profiler.func_219895_b("translucent terrain");
        if (this.shouldRenderTranslucent) {
            levelRenderer.invokeRenderChunkLayer(RenderType.func_228645_f_(), modelView, cameraX, cameraY, cameraZ);
        }
        if (this.renderBuffersExt != null) {
            this.renderBuffersExt.endLevelRendering();
        }
        this.debugStringTerrain = ((WorldRenderer)levelRenderer).func_72735_c();
        this.profiler.func_219895_b("generate mipmaps");
        this.generateMipmaps();
        this.profiler.func_219895_b("restore gl state");
        this.restoreGlState();
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)levelRenderer)).restoreState();
        }
        levelRenderer.setRenderBuffers(playerBuffers);
        ACTIVE = false;
        this.profiler.func_76319_b();
        this.profiler.func_219895_b("updatechunks");
    }

    public void addDebugText(List<String> messages) {
        messages.add("[Oculus] Shadow Maps: " + this.debugStringOverall);
        messages.add("[Oculus] Shadow Distance Terrain: " + this.terrainFrustumHolder.getDistanceInfo() + " Entity: " + this.entityFrustumHolder.getDistanceInfo());
        messages.add("[Oculus] Shadow Culling Terrain: " + this.terrainFrustumHolder.getCullingInfo() + " Entity: " + this.entityFrustumHolder.getCullingInfo());
        messages.add("[Oculus] Shadow Terrain: " + this.debugStringTerrain + (this.shouldRenderTerrain ? "" : " (no terrain) ") + (this.shouldRenderTranslucent ? "" : "(no translucent)"));
        messages.add("[Oculus] Shadow Entities: " + this.getEntitiesDebugString());
        messages.add("[Oculus] Shadow Block Entities: " + this.getBlockEntitiesDebugString());
        if (this.buffers instanceof DrawCallTrackingRenderBuffers && (this.shouldRenderEntities || this.shouldRenderPlayer)) {
            DrawCallTrackingRenderBuffers drawCallTracker = (DrawCallTrackingRenderBuffers)this.buffers;
            messages.add("[Oculus] Shadow Entity Batching: " + BatchingDebugMessageHelper.getDebugMessage(drawCallTracker));
        }
    }

    private String getEntitiesDebugString() {
        return this.shouldRenderEntities || this.shouldRenderPlayer ? this.renderedShadowEntities + "/" + Minecraft.func_71410_x().field_71441_e.func_217425_f() : "disabled by pack";
    }

    private String getBlockEntitiesDebugString() {
        return this.shouldRenderBlockEntities ? this.renderedShadowBlockEntities + "/" + Minecraft.func_71410_x().field_71441_e.field_147482_g.size() : "disabled by pack";
    }

    static {
        ACTIVE = false;
    }

    private static class MipmapPass {
        private final int texture;
        private final int targetFilteringMode;

        public MipmapPass(int texture, int targetFilteringMode) {
            this.texture = texture;
            this.targetFilteringMode = targetFilteringMode;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getTargetFilteringMode() {
            return this.targetFilteringMode;
        }
    }
}

