/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import net.coderbot.iris.IrisLogging;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.transform.BuiltinUniformReplacementTransformer;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;

public class SodiumTerrainPipeline {
    String terrainVertex;
    String terrainGeometry;
    String terrainFragment;
    String translucentVertex;
    String translucentGeometry;
    String translucentFragment;
    String shadowVertex;
    String shadowGeometry;
    String shadowFragment;
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;

    public SodiumTerrainPipeline(WorldRenderingPipeline parent, ProgramSet programSet, IntFunction<ProgramSamplers> createTerrainSamplers, IntFunction<ProgramSamplers> createShadowSamplers, IntFunction<ProgramImages> createTerrainImages, IntFunction<ProgramImages> createShadowImages) {
        this.parent = Objects.requireNonNull(parent);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), terrainSource);
        Optional<ProgramSource> shadowSource = programSet.getShadow();
        this.programSet = programSet;
        terrainSource.ifPresent(sources -> {
            this.terrainVertex = sources.getVertexSource().orElse(null);
            this.terrainGeometry = sources.getGeometrySource().orElse(null);
            this.terrainFragment = sources.getFragmentSource().orElse(null);
        });
        translucentSource.ifPresent(sources -> {
            this.translucentVertex = sources.getVertexSource().orElse(null);
            this.translucentGeometry = sources.getGeometrySource().orElse(null);
            this.translucentFragment = sources.getFragmentSource().orElse(null);
        });
        shadowSource.ifPresent(sources -> {
            this.shadowVertex = sources.getVertexSource().orElse(null);
            this.shadowGeometry = sources.getGeometrySource().orElse(null);
            this.shadowFragment = sources.getFragmentSource().orElse(null);
        });
        if (this.terrainVertex != null) {
            this.terrainVertex = SodiumTerrainPipeline.transformVertexShader(this.terrainVertex);
        }
        if (this.translucentVertex != null) {
            this.translucentVertex = SodiumTerrainPipeline.transformVertexShader(this.translucentVertex);
        }
        if (this.shadowVertex != null) {
            this.shadowVertex = SodiumTerrainPipeline.transformVertexShader(this.shadowVertex);
        }
        if (this.terrainFragment != null) {
            this.terrainFragment = SodiumTerrainPipeline.transformFragmentShader(this.terrainFragment);
        }
        if (this.translucentFragment != null) {
            this.translucentFragment = SodiumTerrainPipeline.transformFragmentShader(this.translucentFragment);
        }
        if (this.shadowFragment != null) {
            this.shadowFragment = SodiumTerrainPipeline.transformFragmentShader(this.shadowFragment);
        }
        this.createTerrainSamplers = createTerrainSamplers;
        this.createShadowSamplers = createShadowSamplers;
        this.createTerrainImages = createTerrainImages;
        this.createShadowImages = createShadowImages;
    }

    private static String transformVertexShader(String base) {
        StringTransformations transformations = new StringTransformations(base);
        String injections = "attribute vec3 a_Pos; // The position of the vertex\nattribute vec4 a_Color; // The color of the vertex\nattribute vec2 a_TexCoord; // The block texture coordinate of the vertex\nattribute vec2 a_LightCoord; // The light map texture coordinate of the vertex\nattribute vec3 a_Normal; // The vertex normal\nuniform mat4 u_ModelViewMatrix;\nuniform mat4 u_ModelViewProjectionMatrix;\nuniform mat4 u_NormalMatrix;\nuniform vec3 u_ModelScale;\nuniform vec2 u_TextureScale;\n\n// The model translation for this draw call.\nattribute vec4 d_ModelOffset;\n\nvec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }";
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, injections);
        transformations.define("gl_Vertex", "vec4((a_Pos * u_ModelScale) + d_ModelOffset.xyz, 1.0)");
        transformations.define("gl_MultiTexCoord0", "vec4(a_TexCoord * u_TextureScale, 0.0, 1.0)");
        transformations.define("gl_Color", "a_Color");
        transformations.define("gl_ModelViewMatrix", "u_ModelViewMatrix");
        transformations.define("gl_ModelViewProjectionMatrix", "u_ModelViewProjectionMatrix");
        transformations.replaceExact("gl_TextureMatrix[0]", "mat4(1.0)");
        transformations.define("gl_NormalMatrix", "mat3(u_NormalMatrix)");
        transformations.define("gl_Normal", "a_Normal");
        transformations.define("ftransform", "iris_ftransform");
        new BuiltinUniformReplacementTransformer("a_LightCoord").apply(transformations);
        if (IrisLogging.ENABLE_SPAM) {
            System.out.println("Final patched vertex source:");
            System.out.println(transformations);
        }
        return transformations.toString();
    }

    private static String transformFragmentShader(String base) {
        StringTransformations transformations = new StringTransformations(base);
        String injections = "uniform mat4 u_ModelViewMatrix;\nuniform mat4 u_ModelViewProjectionMatrix;\nuniform mat4 u_NormalMatrix;\n";
        transformations.define("gl_ModelViewMatrix", "u_ModelViewMatrix");
        transformations.define("gl_ModelViewProjectionMatrix", "u_ModelViewProjectionMatrix");
        transformations.replaceExact("gl_TextureMatrix[0]", "mat4(1.0)");
        transformations.define("gl_NormalMatrix", "mat3(u_NormalMatrix)");
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, injections);
        if (IrisLogging.ENABLE_SPAM) {
            System.out.println("Final patched fragment source:");
            System.out.println(transformations);
        }
        return transformations.toString();
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return Optional.ofNullable(this.terrainVertex);
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return Optional.ofNullable(this.terrainGeometry);
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return Optional.ofNullable(this.terrainFragment);
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return Optional.ofNullable(this.translucentVertex);
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return Optional.ofNullable(this.translucentGeometry);
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return Optional.ofNullable(this.translucentFragment);
    }

    public Optional<String> getShadowVertexShaderSource() {
        return Optional.ofNullable(this.shadowVertex);
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return Optional.ofNullable(this.shadowGeometry);
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return Optional.ofNullable(this.shadowFragment);
    }

    public ProgramUniforms initUniforms(int programId) {
        ProgramUniforms.Builder uniforms = ProgramUniforms.builder("<sodium shaders>", programId);
        CommonUniforms.addCommonUniforms(uniforms, this.programSet.getPack().getIdMap(), this.programSet.getPackDirectives(), this.parent.getFrameUpdateNotifier());
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        return uniforms.buildUniforms();
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int programId) {
        return this.createTerrainSamplers.apply(programId);
    }

    public ProgramSamplers initShadowSamplers(int programId) {
        return this.createShadowSamplers.apply(programId);
    }

    public ProgramImages initTerrainImages(int programId) {
        return this.createTerrainImages.apply(programId);
    }

    public ProgramImages initShadowImages(int programId) {
        return this.createShadowImages.apply(programId);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }
}

