/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.include.IncludeProcessor;
import net.coderbot.iris.shaderpack.include.ShaderPackSourceNames;
import net.coderbot.iris.shaderpack.option.ProfileSet;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shaderpack.transform.line.LineTransform;
import net.coderbot.iris.shaderpack.transform.line.VersionDirectiveNormalizer;
import org.jetbrains.annotations.Nullable;

public class ShaderPack {
    private static final Gson GSON = new Gson();
    private final ProgramSet base;
    @Nullable
    private final ProgramSet overworld;
    private final ProgramSet nether;
    private final ProgramSet end;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new EnumMap(TextureStage.class);
    private final CustomTextureData customNoiseTexture;
    private final ShaderPackOptions shaderPackOptions;
    private final OptionMenuContainer menuContainer;
    private final ProfileSet.ProfileResult profile;
    private final String profileInfo;

    public ShaderPack(Path root, Iterable<StringPair> environmentDefines) throws IOException {
        this(root, Collections.emptyMap(), environmentDefines);
    }

    public ShaderPack(Path root, Map<String, String> changedConfigs, Iterable<StringPair> environmentDefines) throws IOException {
        Objects.requireNonNull(root);
        ImmutableList.Builder starts = ImmutableList.builder();
        ImmutableList<String> potentialFileNames = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/"), potentialFileNames);
        boolean hasWorld0 = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/world0"), potentialFileNames);
        boolean hasNether = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/world-1"), potentialFileNames);
        boolean hasEnd = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/world1"), potentialFileNames);
        IncludeGraph graph = new IncludeGraph(root, (ImmutableList<AbsolutePackPath>)starts.build());
        if (!graph.getFailures().isEmpty()) {
            graph.getFailures().forEach((path, error) -> Iris.logger.error("{}", error.toString()));
            throw new IOException("Failed to resolve some #include directives, see previous messages for details");
        }
        this.languageMap = new LanguageMap(root.resolve("lang"));
        this.shaderPackOptions = new ShaderPackOptions(graph, changedConfigs);
        graph = this.shaderPackOptions.getIncludes();
        ShaderProperties shaderProperties = ShaderPack.loadProperties(root, "shaders.properties").map(source -> new ShaderProperties((String)source, this.shaderPackOptions, environmentDefines)).orElseGet(ShaderProperties::empty);
        ProfileSet profiles = ProfileSet.fromTree(shaderProperties.getProfiles(), this.shaderPackOptions.getOptionSet());
        this.profile = profiles.scan(this.shaderPackOptions.getOptionSet(), this.shaderPackOptions.getOptionValues());
        ArrayList disabledPrograms = new ArrayList();
        this.profile.current.ifPresent(profile -> disabledPrograms.addAll(profile.disabledPrograms));
        this.menuContainer = new OptionMenuContainer(shaderProperties, this.shaderPackOptions, profiles);
        String profileName = this.getCurrentProfileName();
        MutableOptionValues profileOptions = new MutableOptionValues(this.shaderPackOptions.getOptionSet(), this.profile.current.map(p -> p.optionValues).orElse(new HashMap()));
        int userOptionsChanged = this.shaderPackOptions.getOptionValues().getOptionsChanged() - profileOptions.getOptionsChanged();
        this.profileInfo = "Profile: " + profileName + " (+" + userOptionsChanged + " option" + (userOptionsChanged == 1 ? "" : "s") + " changed by user)";
        Iris.logger.info(this.profileInfo);
        IncludeProcessor includeProcessor = new IncludeProcessor(graph);
        Function<AbsolutePackPath, String> sourceProvider = path -> {
            String pathString;
            String programString = pathString.substring((pathString = path.getPathString()).indexOf("/") == 0 ? 1 : 0, pathString.lastIndexOf("."));
            if (disabledPrograms.contains(programString)) {
                return null;
            }
            ImmutableList<String> lines = includeProcessor.getIncludedFile((AbsolutePackPath)path);
            if (lines == null) {
                return null;
            }
            lines = LineTransform.apply(lines, VersionDirectiveNormalizer.INSTANCE);
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                builder.append(line);
                builder.append('\n');
            }
            String source = builder.toString();
            source = JcppProcessor.glslPreprocessSource(source, environmentDefines);
            return source;
        };
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/"), sourceProvider, shaderProperties, this);
        this.overworld = ShaderPack.loadOverrides(hasWorld0, AbsolutePackPath.fromAbsolutePath("/world0"), sourceProvider, shaderProperties, this);
        this.nether = ShaderPack.loadOverrides(hasNether, AbsolutePackPath.fromAbsolutePath("/world-1"), sourceProvider, shaderProperties, this);
        this.end = ShaderPack.loadOverrides(hasEnd, AbsolutePackPath.fromAbsolutePath("/world1"), sourceProvider, shaderProperties, this);
        this.idMap = new IdMap(root, this.shaderPackOptions, environmentDefines);
        this.customNoiseTexture = shaderProperties.getNoiseTexturePath().map(path -> {
            try {
                return this.readTexture(root, (String)path);
            }
            catch (IOException e) {
                Iris.logger.error("Unable to read the custom noise texture at " + path, e);
                return null;
            }
        }).orElse(null);
        shaderProperties.getCustomTextures().forEach((textureStage, customTexturePropertiesMap) -> {
            Object2ObjectOpenHashMap innerCustomTextureDataMap = new Object2ObjectOpenHashMap();
            customTexturePropertiesMap.forEach((arg_0, arg_1) -> this.lambda$new$6((Object2ObjectMap)innerCustomTextureDataMap, root, arg_0, arg_1));
            this.customTextureDataMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, CustomTextureData>)innerCustomTextureDataMap);
        });
    }

    private String getCurrentProfileName() {
        return this.profile.current.map(p -> p.name).orElse("Custom");
    }

    public String getProfileInfo() {
        return this.profileInfo;
    }

    @Nullable
    private static ProgramSet loadOverrides(boolean has, AbsolutePackPath path, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack) {
        if (has) {
            return new ProgramSet(path, sourceProvider, shaderProperties, pack);
        }
        return null;
    }

    private static Optional<String> loadProperties(Path shaderPath, String name) {
        String fileContents = ShaderPack.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        return Optional.of(fileContents);
    }

    public CustomTextureData readTexture(Path root, String path) throws IOException {
        CustomTextureData customTextureData;
        if (path.contains(":")) {
            String[] parts = path.split(":");
            if (parts.length > 2) {
                Iris.logger.warn("Resource location " + path + " contained more than two parts?");
            }
            customTextureData = parts[0].equals("minecraft") && (parts[1].equals("dynamic/lightmap_1") || parts[1].equals("dynamic/light_map_1")) ? new CustomTextureData.LightmapMarker() : new CustomTextureData.ResourceData(parts[0], parts[1]);
        } else {
            JsonObject meta;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            boolean blur = false;
            boolean clamp = false;
            String mcMetaPath = path + ".mcmeta";
            Path mcMetaResolvedPath = root.resolve(mcMetaPath);
            if (Files.exists(mcMetaResolvedPath, new LinkOption[0]) && (meta = this.loadMcMeta(mcMetaResolvedPath)).get("texture") != null) {
                if (meta.get("texture").getAsJsonObject().get("blur") != null) {
                    blur = meta.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                }
                if (meta.get("texture").getAsJsonObject().get("clamp") != null) {
                    clamp = meta.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
                }
            }
            byte[] content = Files.readAllBytes(root.resolve(path));
            customTextureData = new CustomTextureData.PngData(new TextureFilteringData(blur, clamp), content);
        }
        return customTextureData;
    }

    private JsonObject loadMcMeta(Path mcMetaPath) throws IOException, JsonParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(mcMetaPath, new OpenOption[0]), StandardCharsets.UTF_8));
        JsonReader jsonReader = new JsonReader((Reader)reader);
        return (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
    }

    private static String readProperties(Path shaderPath, String name) {
        try {
            return new String(Files.readAllBytes(shaderPath.resolve(name)), StandardCharsets.ISO_8859_1);
        }
        catch (NoSuchFileException e) {
            Iris.logger.debug("An " + name + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException e) {
            Iris.logger.error("An IOException occurred reading " + name + " from the current shaderpack", e);
            return null;
        }
    }

    public ProgramSet getProgramSet(DimensionId dimension) {
        ProgramSet overrides;
        switch (dimension) {
            case OVERWORLD: {
                overrides = this.overworld;
                break;
            }
            case NETHER: {
                overrides = this.nether;
                break;
            }
            case END: {
                overrides = this.end;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dimension " + (Object)((Object)dimension));
            }
        }
        if (overrides != null) {
            return overrides;
        }
        return this.base;
    }

    public IdMap getIdMap() {
        return this.idMap;
    }

    public EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    public ShaderPackOptions getShaderPackOptions() {
        return this.shaderPackOptions;
    }

    public OptionMenuContainer getMenuContainer() {
        return this.menuContainer;
    }

    private /* synthetic */ void lambda$new$6(Object2ObjectMap innerCustomTextureDataMap, Path root, String samplerName, String path) {
        try {
            innerCustomTextureDataMap.put((Object)samplerName, (Object)this.readTexture(root, path));
        }
        catch (IOException e) {
            Iris.logger.error("Unable to read the custom texture at " + path, e);
        }
    }
}

