/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.discovery;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;

public class ShaderpackDirectoryManager {
    private final Path root;

    public ShaderpackDirectoryManager(Path root) {
        this.root = root;
    }

    public void copyPackIntoDirectory(String name, Path source) throws IOException {
        Path target = Iris.getShaderpacksDirectory().resolve(name);
        Files.copy(source, target, new CopyOption[0]);
        if (Files.isDirectory(source, new LinkOption[0])) {
            for (Path p2 : Files.walk(source, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList())) {
                Path folder = source.relativize(p2);
                if (Files.exists(folder, new LinkOption[0])) continue;
                Files.createDirectory(target.resolve(folder), new FileAttribute[0]);
            }
            for (Path p2 : Files.walk(source, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toSet())) {
                Path file = source.relativize(p2);
                Files.copy(p2, target.resolve(file), new CopyOption[0]);
            }
        }
    }

    public Collection<String> enumerate() throws IOException {
        return Files.list(this.root).filter(Iris::isValidShaderpack).map(path -> path.getFileName().toString()).collect(Collectors.toList());
    }

    public URI getDirectoryUri() {
        return this.root.toUri();
    }
}

