/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.Arrays;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.rendertarget.DepthTexture;
import org.lwjgl.opengl.GL;

public class ShadowRenderTargets {
    public static int MAX_SHADOW_RENDER_TARGETS = 8;
    private final int[] targets;
    private final InternalTextureFormat[] formats;
    private final DepthTexture depthTexture;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer framebuffer;
    private final GlFramebuffer noTranslucentFB;
    private final int resolution;
    private static final IntBuffer NULL_BUFFER = null;
    private boolean firstTranslucentCopy;
    private static final boolean supportsFramebufferBlitting = GL.getCapabilities().OpenGL30 || GL.getCapabilities().GL_EXT_framebuffer_blit;

    public ShadowRenderTargets(int resolution, InternalTextureFormat[] formats) {
        if (formats.length > MAX_SHADOW_RENDER_TARGETS) {
            throw new IllegalStateException("Too many shadow render targets, requested " + formats.length + " but only " + MAX_SHADOW_RENDER_TARGETS + " are allowed.");
        }
        this.formats = Arrays.copyOf(formats, formats.length);
        this.resolution = resolution;
        int[] drawBuffers = new int[formats.length];
        this.targets = new int[formats.length];
        GlStateManager.func_242998_a((int[])this.targets);
        this.depthTexture = new DepthTexture(resolution, resolution, DepthBufferFormat.DEPTH);
        this.noTranslucents = new DepthTexture(resolution, resolution, DepthBufferFormat.DEPTH);
        this.framebuffer = new GlFramebuffer();
        this.noTranslucentFB = new GlFramebuffer();
        this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId());
        this.noTranslucentFB.addDepthAttachment(this.noTranslucents.getTextureId());
        for (int i = 0; i < formats.length; ++i) {
            InternalTextureFormat format = formats[i];
            RenderSystem.bindTexture((int)this.targets[i]);
            GlStateManager.func_227647_a_((int)3553, (int)0, (int)format.getGlFormat(), (int)resolution, (int)resolution, (int)0, (int)PixelFormat.RGBA.getGlFormat(), (int)PixelType.UNSIGNED_BYTE.getGlFormat(), (IntBuffer)NULL_BUFFER);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
            this.framebuffer.addColorAttachment(i, this.targets[i]);
            this.noTranslucentFB.addColorAttachment(i, this.targets[i]);
            drawBuffers[i] = i;
        }
        this.framebuffer.drawBuffers(drawBuffers);
        this.noTranslucentFB.drawBuffers(drawBuffers);
        this.firstTranslucentCopy = true;
        RenderSystem.bindTexture((int)0);
    }

    public void copyPreTranslucentDepth() {
        if (this.firstTranslucentCopy && supportsFramebufferBlitting) {
            this.firstTranslucentCopy = false;
            this.framebuffer.bindAsReadBuffer();
            this.noTranslucentFB.bindAsDrawBuffer();
            GlStateManager.func_237510_a_((int)0, (int)0, (int)this.resolution, (int)this.resolution, (int)0, (int)0, (int)this.resolution, (int)this.resolution, (int)256, (int)9728);
        } else {
            DepthCopyStrategy.fastest(false).copy(this.framebuffer, this.depthTexture.getTextureId(), null, this.noTranslucents.getTextureId(), this.resolution, this.resolution);
        }
    }

    public GlFramebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public DepthTexture getDepthTexture() {
        return this.depthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public int getNumColorTextures() {
        return this.targets.length;
    }

    public int getColorTextureId(int index) {
        return this.targets[index];
    }

    public InternalTextureFormat getColorTextureFormat(int index) {
        return this.formats[index];
    }

    public void destroy() {
        this.framebuffer.destroy();
        GlStateManager.func_242999_b((int[])this.targets);
        this.depthTexture.destroy();
        this.noTranslucents.destroy();
    }
}

