/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class AdvancedShadowCullingFrustum
extends ClippingHelper {
    private static final int MAX_CLIPPING_PLANES = 30;
    private final Vector4f[] planes = new Vector4f[30];
    private int planeCount = 0;
    private double x;
    private double y;
    private double z;
    private final Vector3f shadowLightVectorFromOrigin;
    private final BoxCuller boxCuller;

    public AdvancedShadowCullingFrustum(Matrix4f playerView, Matrix4f playerProjection, Vector3f shadowLightVectorFromOrigin, BoxCuller boxCuller) {
        super(new Matrix4f(), new Matrix4f());
        this.shadowLightVectorFromOrigin = shadowLightVectorFromOrigin;
        BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes(playerView, playerProjection);
        boolean[] isBack = this.addBackPlanes(baseClippingPlanes);
        this.addEdgePlanes(baseClippingPlanes, isBack);
        this.boxCuller = boxCuller;
    }

    private void addPlane(Vector4f plane) {
        this.planes[this.planeCount] = plane;
        ++this.planeCount;
    }

    private boolean[] addBackPlanes(BaseClippingPlanes baseClippingPlanes) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        boolean[] isBack = new boolean[planes.length];
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            Vector4f plane = planes[planeIndex];
            Vector3f planeNormal = this.truncate(plane);
            float dot = planeNormal.func_195903_b(this.shadowLightVectorFromOrigin);
            boolean back = (double)dot > 0.0;
            boolean edge = (double)dot == 0.0;
            isBack[planeIndex] = back;
            if (!back && !edge) continue;
            this.addPlane(plane);
        }
        return isBack;
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] isBack) {
        Vector4f[] planes = baseClippingPlanes.getPlanes();
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            if (!isBack[planeIndex]) continue;
            Vector4f plane = planes[planeIndex];
            NeighboringPlaneSet neighbors = NeighboringPlaneSet.forPlane(planeIndex);
            if (!isBack[neighbors.getPlane0()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane0()]);
            }
            if (!isBack[neighbors.getPlane1()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane1()]);
            }
            if (!isBack[neighbors.getPlane2()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane2()]);
            }
            if (isBack[neighbors.getPlane3()]) continue;
            this.addEdgePlane(plane, planes[neighbors.getPlane3()]);
        }
    }

    private Vector3f truncate(Vector4f base) {
        return new Vector3f(base.func_195910_a(), base.func_195913_b(), base.func_195914_c());
    }

    private Vector4f extend(Vector3f base, float w) {
        return new Vector4f(base.func_195899_a(), base.func_195900_b(), base.func_195902_c(), w);
    }

    private float lengthSquared(Vector3f v) {
        float x = v.func_195899_a();
        float y = v.func_195900_b();
        float z = v.func_195902_c();
        return x * x + y * y + z * z;
    }

    private Vector3f cross(Vector3f first, Vector3f second) {
        Vector3f result = new Vector3f(first.func_195899_a(), first.func_195900_b(), first.func_195902_c());
        result.func_195896_c(second);
        return result;
    }

    private void addEdgePlane(Vector4f backPlane4, Vector4f frontPlane4) {
        Vector3f backPlaneNormal = this.truncate(backPlane4);
        Vector3f frontPlaneNormal = this.truncate(frontPlane4);
        Vector3f intersection = this.cross(backPlaneNormal, frontPlaneNormal);
        Vector3f edgePlaneNormal = this.cross(intersection, this.shadowLightVectorFromOrigin);
        Vector3f ixb = this.cross(intersection, backPlaneNormal);
        Vector3f fxi = this.cross(frontPlaneNormal, intersection);
        ixb.func_195898_a(-frontPlane4.func_195915_d());
        fxi.func_195898_a(-backPlane4.func_195915_d());
        ixb.func_229189_a_(fxi);
        Vector3f point = ixb;
        point.func_195898_a(1.0f / this.lengthSquared(intersection));
        float d = edgePlaneNormal.func_195903_b(point);
        float w = -d;
        Vector4f plane = this.extend(edgePlaneNormal, w);
        this.addPlane(plane);
    }

    public void func_228952_a_(double cameraX, double cameraY, double cameraZ) {
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(cameraX, cameraY, cameraZ);
        }
        this.x = cameraX;
        this.y = cameraY;
        this.z = cameraZ;
    }

    public boolean func_228957_a_(AxisAlignedBB aabb) {
        if (this.boxCuller != null && this.boxCuller.isCulled(aabb)) {
            return false;
        }
        return this.isVisible(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public boolean fastAabbTest(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.boxCuller != null && this.boxCuller.isCulled(minX, minY, minZ, maxX, maxY, maxZ)) {
            return false;
        }
        return this.isVisible(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return false;
    }

    private boolean isVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        float f = (float)(minX - this.x);
        float g = (float)(minY - this.y);
        float h = (float)(minZ - this.z);
        float i = (float)(maxX - this.x);
        float j = (float)(maxY - this.y);
        float k = (float)(maxZ - this.z);
        return this.isAnyCornerVisible(f, g, h, i, j, k);
    }

    private boolean isAnyCornerVisible(float x1, float y1, float z1, float x2, float y2, float z2) {
        for (int i = 0; i < this.planeCount; ++i) {
            Vector4f plane = this.planes[i];
            if (plane.func_229373_a_(new Vector4f(x1, y1, z1, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x2, y1, z1, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x1, y2, z1, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x2, y2, z1, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x1, y1, z2, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x2, y1, z2, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x1, y2, z2, 1.0f)) > 0.0f || plane.func_229373_a_(new Vector4f(x2, y2, z2, 1.0f)) > 0.0f) continue;
            return false;
        }
        return true;
    }
}

