/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.minecraft.client.Minecraft;

public class CameraUniforms {
    private static final Minecraft client = Minecraft.func_71410_x();

    private CameraUniforms() {
    }

    public static void addCameraUniforms(UniformHolder uniforms, FrameUpdateNotifier notifier) {
        CameraPositionTracker tracker = new CameraPositionTracker(notifier);
        uniforms.uniform1f(UniformUpdateFrequency.ONCE, "near", () -> 0.05).uniform1f(UniformUpdateFrequency.PER_FRAME, "far", CameraUniforms::getRenderDistanceInBlocks).uniform3d(UniformUpdateFrequency.PER_FRAME, "cameraPosition", tracker::getCurrentCameraPosition).uniform3d(UniformUpdateFrequency.PER_FRAME, "previousCameraPosition", tracker::getPreviousCameraPosition);
    }

    private static int getRenderDistanceInBlocks() {
        return CameraUniforms.client.field_71474_y.field_151451_c * 16;
    }

    public static Vector3d getUnshiftedCameraPosition() {
        return JomlConversions.fromVec3(CameraUniforms.client.field_71460_t.func_215316_n().func_216785_c());
    }

    static class CameraPositionTracker {
        private static final double WALK_RANGE = 30000.0;
        private static final double TP_RANGE = 1000.0;
        private Vector3d previousCameraPosition = new Vector3d();
        private Vector3d currentCameraPosition = new Vector3d();
        private final Vector3d shift = new Vector3d();

        CameraPositionTracker(FrameUpdateNotifier notifier) {
            notifier.addListener(this::update);
        }

        private void update() {
            this.previousCameraPosition = this.currentCameraPosition;
            this.currentCameraPosition = CameraUniforms.getUnshiftedCameraPosition().add(this.shift);
            this.updateShift();
        }

        private void updateShift() {
            double dX = CameraPositionTracker.getShift(this.currentCameraPosition.x, this.previousCameraPosition.x);
            double dZ = CameraPositionTracker.getShift(this.currentCameraPosition.z, this.previousCameraPosition.z);
            if (dX != 0.0 || dZ != 0.0) {
                this.applyShift(dX, dZ);
            }
        }

        private static double getShift(double value, double prevValue) {
            if (Math.abs(value) > 30000.0 || Math.abs(value - prevValue) > 1000.0) {
                return -(value - value % 30000.0);
            }
            return 0.0;
        }

        private void applyShift(double dX, double dZ) {
            this.shift.x += dX;
            this.currentCameraPosition.x += dX;
            this.previousCameraPosition.x += dX;
            this.shift.z += dZ;
            this.currentCameraPosition.z += dZ;
            this.previousCameraPosition.z += dZ;
        }

        public Vector3d getCurrentCameraPosition() {
            return this.currentCameraPosition;
        }

        public Vector3d getPreviousCameraPosition() {
            return this.previousCameraPosition;
        }
    }
}

