/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.BlockStarLightEngine;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.SkyStarLightEngine;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import ca.spottedleaf.starlight.common.world.ExtendedWorld;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public final class StarLightInterface {
    public static final TicketType<ChunkPos> CHUNK_WORK_TICKET = TicketType.func_219484_a((String)"starlight_chunk_work_ticket", (p1, p2) -> Long.compare(p1.func_201841_a(), p2.func_201841_a()));
    protected final World world;
    protected final IChunkLightProvider lightAccess;
    protected final ArrayDeque<SkyStarLightEngine> cachedSkyPropagators;
    protected final ArrayDeque<BlockStarLightEngine> cachedBlockPropagators;
    protected final LightQueue lightQueue = new LightQueue(this);
    protected final IWorldLightListener skyReader;
    protected final IWorldLightListener blockReader;
    protected final boolean isClientSide;
    protected final int minSection;
    protected final int maxSection;
    protected final int minLightSection;
    protected final int maxLightSection;

    public StarLightInterface(IChunkLightProvider lightAccess, boolean hasSkyLight, boolean hasBlockLight) {
        this.lightAccess = lightAccess;
        this.world = lightAccess == null ? null : (World)lightAccess.func_212864_k_();
        this.cachedSkyPropagators = hasSkyLight && lightAccess != null ? new ArrayDeque() : null;
        this.cachedBlockPropagators = hasBlockLight && lightAccess != null ? new ArrayDeque() : null;
        boolean bl = this.isClientSide = !(this.world instanceof ServerWorld);
        if (this.world == null) {
            this.minSection = 0;
            this.maxSection = 15;
            this.minLightSection = -1;
            this.maxLightSection = 16;
        } else {
            this.minSection = WorldUtil.getMinSection(this.world);
            this.maxSection = WorldUtil.getMaxSection(this.world);
            this.minLightSection = WorldUtil.getMinLightSection(this.world);
            this.maxLightSection = WorldUtil.getMaxLightSection(this.world);
        }
        this.skyReader = !hasSkyLight ? IWorldLightListener.Dummy.INSTANCE : new IWorldLightListener(){

            public NibbleArray func_215612_a(SectionPos pos) {
                IChunk chunk = StarLightInterface.this.getAnyChunkNow(pos.func_177958_n(), pos.func_177952_p());
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.func_217310_r() || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
                    return null;
                }
                int sectionY = pos.func_177956_o();
                if (sectionY > StarLightInterface.this.maxLightSection || sectionY < StarLightInterface.this.minLightSection) {
                    return null;
                }
                if (((ExtendedChunk)chunk).getSkyEmptinessMap() == null) {
                    return null;
                }
                return ((ExtendedChunk)chunk).getSkyNibbles()[sectionY - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int func_215611_b(BlockPos blockPos) {
                int currY;
                boolean[] emptinessMap;
                int x = blockPos.func_177958_n();
                int y = blockPos.func_177956_o();
                int z = blockPos.func_177952_p();
                IChunk chunk = StarLightInterface.this.getAnyChunkNow(x >> 4, z >> 4);
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.func_217310_r() || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
                    return 15;
                }
                int sectionY = y >> 4;
                if (sectionY > StarLightInterface.this.maxLightSection) {
                    return 15;
                }
                if (sectionY < StarLightInterface.this.minLightSection) {
                    sectionY = StarLightInterface.this.minLightSection;
                    y = sectionY << 4;
                }
                SWMRNibbleArray[] nibbles = ((ExtendedChunk)chunk).getSkyNibbles();
                SWMRNibbleArray immediate = nibbles[sectionY - StarLightInterface.this.minLightSection];
                if (StarLightInterface.this.isClientSide) {
                    if (!immediate.isNullNibbleUpdating()) {
                        return immediate.getUpdating(x, y, z);
                    }
                } else if (!immediate.isNullNibbleVisible()) {
                    return immediate.getVisible(x, y, z);
                }
                if ((emptinessMap = ((ExtendedChunk)chunk).getSkyEmptinessMap()) == null) {
                    return 15;
                }
                int lowestY = StarLightInterface.this.minLightSection - 1;
                for (currY = StarLightInterface.this.maxSection; currY >= StarLightInterface.this.minSection; --currY) {
                    if (emptinessMap[currY - StarLightInterface.this.minSection]) continue;
                    lowestY = currY;
                    break;
                }
                if (sectionY > lowestY) {
                    return 15;
                }
                for (currY = sectionY + 1; currY <= StarLightInterface.this.maxLightSection; ++currY) {
                    SWMRNibbleArray nibble = nibbles[currY - StarLightInterface.this.minLightSection];
                    if (StarLightInterface.this.isClientSide) {
                        if (nibble.isNullNibbleUpdating()) continue;
                        return nibble.getUpdating(x, 0, z);
                    }
                    if (nibble.isNullNibbleVisible()) continue;
                    return nibble.getVisible(x, 0, z);
                }
                return 15;
            }

            public void func_215566_a(SectionPos pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.blockReader = !hasBlockLight ? IWorldLightListener.Dummy.INSTANCE : new IWorldLightListener(){

            public NibbleArray func_215612_a(SectionPos pos) {
                IChunk chunk = StarLightInterface.this.getAnyChunkNow(pos.func_177958_n(), pos.func_177952_p());
                if (chunk == null || pos.func_177956_o() < StarLightInterface.this.minLightSection || pos.func_177956_o() > StarLightInterface.this.maxLightSection) {
                    return null;
                }
                return ((ExtendedChunk)chunk).getBlockNibbles()[pos.func_177956_o() - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int func_215611_b(BlockPos blockPos) {
                int cx = blockPos.func_177958_n() >> 4;
                int cy = blockPos.func_177956_o() >> 4;
                int cz = blockPos.func_177952_p() >> 4;
                if (cy < StarLightInterface.this.minLightSection || cy > StarLightInterface.this.maxLightSection) {
                    return 0;
                }
                IChunk chunk = StarLightInterface.this.getAnyChunkNow(cx, cz);
                if (chunk == null) {
                    return 0;
                }
                SWMRNibbleArray nibble = ((ExtendedChunk)chunk).getBlockNibbles()[cy - StarLightInterface.this.minLightSection];
                if (StarLightInterface.this.isClientSide) {
                    return nibble.getUpdating(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                }
                return nibble.getVisible(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            }

            public void func_215566_a(SectionPos pos, boolean notReady) {
            }
        };
    }

    public IWorldLightListener getSkyReader() {
        return this.skyReader;
    }

    public IWorldLightListener getBlockReader() {
        return this.blockReader;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public IChunk getAnyChunkNow(int chunkX, int chunkZ) {
        if (this.world == null) {
            return null;
        }
        return ((ExtendedWorld)this.world).getAnyChunkImmediately(chunkX, chunkZ);
    }

    public boolean hasUpdates() {
        return !this.lightQueue.isEmpty();
    }

    public World getWorld() {
        return this.world;
    }

    public IChunkLightProvider getLightAccess() {
        return this.lightAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SkyStarLightEngine getSkyLightEngine() {
        SkyStarLightEngine ret;
        if (this.cachedSkyPropagators == null) {
            return null;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedSkyPropagators.pollFirst();
        }
        if (ret == null) {
            return new SkyStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseSkyLightEngine(SkyStarLightEngine engine) {
        if (this.cachedSkyPropagators == null) {
            return;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            this.cachedSkyPropagators.addFirst(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BlockStarLightEngine getBlockLightEngine() {
        BlockStarLightEngine ret;
        if (this.cachedBlockPropagators == null) {
            return null;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedBlockPropagators.pollFirst();
        }
        if (ret == null) {
            return new BlockStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseBlockLightEngine(BlockStarLightEngine engine) {
        if (this.cachedBlockPropagators == null) {
            return;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            this.cachedBlockPropagators.addFirst(engine);
        }
    }

    public CompletableFuture<Void> blockChange(BlockPos pos) {
        if (this.world == null || pos.func_177956_o() < WorldUtil.getMinBlockY(this.world) || pos.func_177956_o() > WorldUtil.getMaxBlockY(this.world)) {
            return null;
        }
        return this.lightQueue.queueBlockChange(pos);
    }

    public CompletableFuture<Void> sectionChange(SectionPos pos, boolean newEmptyValue) {
        if (this.world == null) {
            return null;
        }
        return this.lightQueue.queueSectionChange(pos, newEmptyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoadInChunk(IChunk chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInChunk(int chunkX, int chunkZ, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(IChunk chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.light(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.light(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relightChunks(Set<ChunkPos> chunks, Consumer<ChunkPos> chunkLightCallback, IntConsumer onComplete) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.relightChunks(this.lightAccess, chunks, blockEngine == null ? chunkLightCallback : null, blockEngine == null ? onComplete : null);
            }
            if (blockEngine != null) {
                blockEngine.relightChunks(this.lightAccess, chunks, chunkLightCallback, onComplete);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void checkChunkEdges(int chunkX, int chunkZ) {
        this.checkSkyEdges(chunkX, chunkZ);
        this.checkBlockEdges(chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ, ShortCollection sections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ, ShortCollection sections) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void scheduleChunkLight(ChunkPos pos, Runnable run) {
        this.lightQueue.queueChunkLighting(pos, run);
    }

    public void removeChunkTasks(ChunkPos pos) {
        this.lightQueue.removeChunk(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateChanges() {
        if (this.lightQueue.isEmpty()) {
            return;
        }
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            LightQueue.ChunkTasks task;
            while ((task = this.lightQueue.removeFirstTask()) != null) {
                if (task.lightTasks != null) {
                    for (Runnable run : task.lightTasks) {
                        run.run();
                    }
                }
                long coordinate = task.chunkCoordinate;
                int chunkX = CoordinateUtils.getChunkX(coordinate);
                int chunkZ = CoordinateUtils.getChunkZ(coordinate);
                Set<BlockPos> positions = task.changedPositions;
                Boolean[] sectionChanges = task.changedSectionSet;
                if (!(skyEngine == null || positions.isEmpty() && sectionChanges == null)) {
                    skyEngine.blocksChangedInChunk(this.lightAccess, chunkX, chunkZ, positions, sectionChanges);
                }
                if (!(blockEngine == null || positions.isEmpty() && sectionChanges == null)) {
                    blockEngine.blocksChangedInChunk(this.lightAccess, chunkX, chunkZ, positions, sectionChanges);
                }
                if (skyEngine != null && task.queuedEdgeChecksSky != null) {
                    skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, (ShortCollection)task.queuedEdgeChecksSky);
                }
                if (blockEngine != null && task.queuedEdgeChecksBlock != null) {
                    blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, (ShortCollection)task.queuedEdgeChecksBlock);
                }
                task.onComplete.complete(null);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    protected static final class LightQueue {
        protected final Long2ObjectLinkedOpenHashMap<ChunkTasks> chunkTasks = new Long2ObjectLinkedOpenHashMap();
        protected final StarLightInterface manager;

        public LightQueue(StarLightInterface manager) {
            this.manager = manager;
        }

        public synchronized boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        public synchronized CompletableFuture<Void> queueBlockChange(BlockPos pos) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            tasks.changedPositions.add(pos.func_185334_h());
            return tasks.onComplete;
        }

        public synchronized CompletableFuture<Void> queueSectionChange(SectionPos pos, boolean newEmptyValue) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.changedSectionSet == null) {
                tasks.changedSectionSet = new Boolean[this.manager.maxSection - this.manager.minSection + 1];
            }
            tasks.changedSectionSet[pos.func_177956_o() - this.manager.minSection] = newEmptyValue;
            return tasks.onComplete;
        }

        public synchronized CompletableFuture<Void> queueChunkLighting(ChunkPos pos, Runnable lightTask) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.lightTasks == null) {
                tasks.lightTasks = new ArrayList<Runnable>();
            }
            tasks.lightTasks.add(lightTask);
            return tasks.onComplete;
        }

        public synchronized CompletableFuture<Void> queueChunkSkylightEdgeCheck(SectionPos pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksSky;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksSky = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            return tasks.onComplete;
        }

        public synchronized CompletableFuture<Void> queueChunkBlocklightEdgeCheck(SectionPos pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksBlock;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksBlock = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            return tasks.onComplete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChunk(ChunkPos pos) {
            ChunkTasks tasks;
            LightQueue lightQueue = this;
            synchronized (lightQueue) {
                tasks = (ChunkTasks)this.chunkTasks.remove(CoordinateUtils.getChunkKey(pos));
            }
            if (tasks != null) {
                tasks.onComplete.complete(null);
            }
        }

        public synchronized ChunkTasks removeFirstTask() {
            if (this.chunkTasks.isEmpty()) {
                return null;
            }
            return (ChunkTasks)this.chunkTasks.removeFirst();
        }

        protected static final class ChunkTasks {
            public final Set<BlockPos> changedPositions = new HashSet<BlockPos>();
            public Boolean[] changedSectionSet;
            public ShortOpenHashSet queuedEdgeChecksSky;
            public ShortOpenHashSet queuedEdgeChecksBlock;
            public List<Runnable> lightTasks;
            public final CompletableFuture<Void> onComplete = new CompletableFuture();
            public final long chunkCoordinate;

            public ChunkTasks(long chunkCoordinate) {
                this.chunkCoordinate = chunkCoordinate;
            }
        }
    }
}

