/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.world;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerMixin {
    @Shadow
    @Final
    private static Logger field_222658_a;
    private static final int STARLIGHT_LIGHT_VERSION = 5;
    private static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    private static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    private static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private static void saveLightHook(ServerWorld world, IChunk chunk, CallbackInfoReturnable<CompoundNBT> cir) {
        try {
            ChunkSerializerMixin.saveLightHookReal(world, chunk, cir);
        }
        catch (Exception ex) {
            field_222658_a.warn("Failed to inject light data into save data for chunk " + chunk.func_76632_l() + ", chunk light will be recalculated on its next load", (Throwable)ex);
        }
    }

    private static void saveLightHookReal(ServerWorld world, IChunk chunk, CallbackInfoReturnable<CompoundNBT> cir) {
        int i;
        int minSection = WorldUtil.getMinLightSection((World)world);
        int maxSection = WorldUtil.getMaxLightSection((World)world);
        CompoundNBT ret = (CompoundNBT)cir.getReturnValue();
        if (ret == null) {
            return;
        }
        SWMRNibbleArray[] blockNibbles = ((ExtendedChunk)chunk).getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = ((ExtendedChunk)chunk).getSkyNibbles();
        CompoundNBT level = ret.func_74775_l("Level");
        boolean lit = chunk.func_217310_r();
        if (lit) {
            level.func_74757_a("isLightOn", false);
        }
        ChunkStatus status = ChunkStatus.func_222591_a((String)level.func_74779_i("Status"));
        CompoundNBT[] sections = new CompoundNBT[maxSection - minSection + 1];
        ListNBT sectionsStored = level.func_150295_c("Sections", 10);
        for (i = 0; i < sectionsStored.size(); ++i) {
            CompoundNBT sectionStored = sectionsStored.func_150305_b(i);
            byte k = sectionStored.func_74771_c("Y");
            sectionStored.func_82580_o("BlockLight");
            sectionStored.func_82580_o("SkyLight");
            if (sectionStored.isEmpty()) continue;
            sections[k - minSection] = sectionStored;
        }
        if (lit && status.func_209003_a(ChunkStatus.field_222614_j)) {
            for (i = minSection; i <= maxSection; ++i) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                CompoundNBT section = sections[i - minSection];
                if (section == null) {
                    section = new CompoundNBT();
                    section.func_74774_a("Y", (byte)i);
                    sections[i - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.func_74773_a("BlockLight", blockNibble.data);
                    }
                    section.func_74768_a(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.func_74773_a("SkyLight", skyNibble.data);
                }
                section.func_74768_a(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (CompoundNBT section : sections) {
            if (section == null) continue;
            sectionsStored.add((Object)section);
        }
        level.func_218657_a("Sections", (INBT)sectionsStored);
        if (lit) {
            level.func_74768_a(STARLIGHT_VERSION_TAG, 5);
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void loadLightHook(ServerWorld world, TemplateManager structureManager, PointOfInterestManager poiStorage, ChunkPos pos, CompoundNBT tag, CallbackInfoReturnable<ChunkPrimer> cir) {
        try {
            ChunkSerializerMixin.loadLightHookReal(world, structureManager, poiStorage, pos, tag, cir);
        }
        catch (Exception ex) {
            field_222658_a.warn("Failed to load light for chunk " + pos + ", light will be recalculated", (Throwable)ex);
        }
    }

    private static void loadLightHookReal(ServerWorld world, TemplateManager structureManager, PointOfInterestManager poiStorage, ChunkPos pos, CompoundNBT tag, CallbackInfoReturnable<ChunkPrimer> cir) {
        int minSection = WorldUtil.getMinLightSection((World)world);
        int maxSection = WorldUtil.getMaxLightSection((World)world);
        ChunkPrimer ret = (ChunkPrimer)cir.getReturnValue();
        if (ret == null) {
            return;
        }
        ret.func_217305_b(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight((World)world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight((World)world);
        CompoundNBT levelTag = tag.func_74775_l("Level");
        boolean lit = levelTag.func_74781_a("isLightOn") != null && levelTag.func_74762_e(STARLIGHT_VERSION_TAG) == 5;
        boolean canReadSky = world.func_230315_m_().func_218272_d();
        ChunkStatus status = ChunkStatus.func_222591_a((String)tag.func_74775_l("Level").func_74779_i("Status"));
        if (lit && status.func_209003_a(ChunkStatus.field_222614_j)) {
            ListNBT sections = levelTag.func_150295_c("Sections", 10);
            for (int i = 0; i < sections.size(); ++i) {
                CompoundNBT sectionData = sections.func_150305_b(i);
                byte y = sectionData.func_74771_c("Y");
                blockNibbles[y - minSection] = sectionData.func_150297_b("BlockLight", 7) ? new SWMRNibbleArray((byte[])sectionData.func_74770_j("BlockLight").clone(), sectionData.func_74762_e(BLOCKLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.func_74762_e(BLOCKLIGHT_STATE_TAG));
                if (!canReadSky) continue;
                skyNibbles[y - minSection] = sectionData.func_150297_b("SkyLight", 7) ? new SWMRNibbleArray((byte[])sectionData.func_74770_j("SkyLight").clone(), sectionData.func_74762_e(SKYLIGHT_STATE_TAG)) : new SWMRNibbleArray(null, sectionData.func_74762_e(SKYLIGHT_STATE_TAG));
            }
        }
        ((ExtendedChunk)ret).setBlockNibbles(blockNibbles);
        ((ExtendedChunk)ret).setSkyNibbles(skyNibbles);
        ret.func_217305_b(lit);
    }
}

