/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.world;

import ca.spottedleaf.starlight.common.light.VariableBlockLightHandler;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.world.ExtendedWorld;
import com.mojang.datafixers.util.Either;
import java.util.function.Supplier;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ServerWorld.class})
public abstract class ServerWorldMixin
extends World
implements ISeedReader,
ExtendedWorld {
    @Unique
    private VariableBlockLightHandler customBlockLightHandler;

    protected ServerWorldMixin(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed) {
        super(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
    }

    @Shadow
    public abstract ServerChunkProvider func_72863_F();

    @Override
    public final VariableBlockLightHandler getCustomLightHandler() {
        return this.customBlockLightHandler;
    }

    @Override
    public final void setCustomLightHandler(VariableBlockLightHandler handler) {
        this.customBlockLightHandler = handler;
    }

    @Override
    public final Chunk getChunkAtImmediately(int chunkX, int chunkZ) {
        ChunkManager storage = this.func_72863_F().field_217237_a;
        ChunkHolder holder = storage.func_219219_b(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (holder == null) {
            return null;
        }
        Either either = holder.func_219301_a(ChunkStatus.field_222617_m).getNow(null);
        return either == null ? null : (Chunk)either.left().orElse(null);
    }

    @Override
    public final IChunk getAnyChunkImmediately(int chunkX, int chunkZ) {
        ChunkManager storage = this.func_72863_F().field_217237_a;
        ChunkHolder holder = storage.func_219219_b(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        return holder == null ? null : holder.func_219287_e();
    }
}

