/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client;

import java.util.List;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ClientHelper {
    public static ClientHelper getInstance() {
        return ClientInternals.getClientHelper();
    }

    public boolean isCheating();

    public void setCheating(boolean var1);

    public boolean tryCheatingEntry(EntryStack<?> var1);

    default public String getModFromItem(Item item) {
        if (item.equals(Items.field_190931_a)) {
            return "";
        }
        return this.getModFromIdentifier(Registry.field_212630_s.func_177774_c((Object)item));
    }

    public void sendDeletePacket();

    default public ITextComponent getFormattedModFromItem(Item item) {
        String mod = this.getModFromItem(item);
        if (mod.isEmpty()) {
            return NarratorChatListener.field_216868_a;
        }
        return new StringTextComponent(mod).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC});
    }

    default public ITextComponent getFormattedModFromIdentifier(ResourceLocation identifier) {
        String mod = this.getModFromIdentifier(identifier);
        if (mod.isEmpty()) {
            return NarratorChatListener.field_216868_a;
        }
        return new StringTextComponent(mod).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC});
    }

    default public ITextComponent getFormattedModFromModId(String modid) {
        String mod = this.getModFromModId(modid);
        if (mod.isEmpty()) {
            return NarratorChatListener.field_216868_a;
        }
        return new StringTextComponent(mod).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC});
    }

    default public List<ITextComponent> appendModIdToTooltips(List<ITextComponent> components, String modId) {
        String modName = ClientHelper.getInstance().getModFromModId(modId);
        boolean alreadyHasMod = false;
        for (ITextComponent s : components) {
            if (!FormattingUtils.stripFormatting(s.getString()).equalsIgnoreCase(modName)) continue;
            alreadyHasMod = true;
            break;
        }
        if (!alreadyHasMod) {
            components.add(ClientHelper.getInstance().getFormattedModFromModId(modId));
        }
        return components;
    }

    public void appendModIdToTooltips(Tooltip var1, String var2);

    default public String getModFromIdentifier(ResourceLocation identifier) {
        if (identifier == null) {
            return "";
        }
        return this.getModFromModId(identifier.func_110624_b());
    }

    public String getModFromModId(String var1);

    public boolean openView(ViewSearchBuilder var1);

    public boolean canUseMovePackets();
}

