/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.favorites;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompoundFavoriteRenderer
extends AbstractRenderer {
    protected NumberAnimator<Double> offset = ValueAnimator.ofDouble();
    protected Rectangle scissorArea = new Rectangle();
    protected long nextSwitch = -1L;
    protected IntFunction<Renderer> renderers;
    protected int count;
    protected boolean showcase;
    protected IntSupplier supplier;

    public CompoundFavoriteRenderer(List<Renderer> renderers) {
        this(true, renderers, null);
    }

    public CompoundFavoriteRenderer(List<Renderer> renderers, IntSupplier supplier) {
        this(false, renderers, supplier);
    }

    protected CompoundFavoriteRenderer(boolean showcase, List<Renderer> renderers, IntSupplier supplier) {
        this(showcase, renderers.size(), renderers::get, supplier);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers) {
        this(true, count, renderers, null);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this(false, count, renderers, supplier);
    }

    public CompoundFavoriteRenderer(boolean showcase, int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this.count = count;
        this.showcase = showcase;
        this.renderers = renderers;
        this.supplier = supplier;
    }

    @Override
    public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.updateAnimator(delta);
        Vector4f vector4f = new Vector4f((float)bounds.x, (float)bounds.y, 0.0f, 1.0f);
        vector4f.func_229372_a_(matrices.func_227866_c_().func_227870_a_());
        Vector4f vector4f2 = new Vector4f((float)bounds.getMaxX(), (float)bounds.getMaxY(), 0.0f, 1.0f);
        vector4f2.func_229372_a_(matrices.func_227866_c_().func_227870_a_());
        this.scissorArea.setBounds((int)vector4f.func_195910_a(), (int)vector4f.func_195913_b(), (int)vector4f2.func_195910_a() - (int)vector4f.func_195910_a(), (int)vector4f2.func_195913_b() - (int)vector4f.func_195913_b());
        ScissorsHandler.INSTANCE.scissor(this.scissorArea);
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, (double)(this.offset.floatValue() * (float)(-bounds.getHeight())), 0.0);
        for (int i = 0; i < this.count; ++i) {
            this.renderers.apply(i).render(matrices, bounds, mouseX, mouseY, delta);
            matrices.func_227861_a_(0.0, (double)bounds.height, 0.0);
        }
        matrices.func_227865_b_();
        ScissorsHandler.INSTANCE.removeLastScissor();
    }

    private void updateAnimator(float delta) {
        this.offset.update((double)delta);
        if (this.showcase) {
            if (this.nextSwitch == -1L) {
                this.nextSwitch = Util.func_211177_b();
            }
            if (Util.func_211177_b() - this.nextSwitch > 1000L) {
                this.nextSwitch = Util.func_211177_b();
                this.offset.setTo((((Double)this.offset.target()).intValue() + 1) % this.count, 500L);
            }
        } else {
            this.offset.setTo(this.supplier.getAsInt() % this.count, 500L);
        }
    }
}

