/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.screen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.SimpleClickArea;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface ScreenRegistry
extends Reloadable<REIClientPlugin> {
    public static ScreenRegistry getInstance() {
        return PluginManager.getClientInstance().get(ScreenRegistry.class);
    }

    public <R extends Screen> List<OverlayDecider> getDeciders(R var1);

    public List<OverlayDecider> getDeciders();

    public void registerDecider(OverlayDecider var1);

    public void registerFocusedStack(FocusedStackProvider var1);

    public <T extends Screen> void registerDraggableStackVisitor(DraggableStackVisitor<T> var1);

    public <T extends Screen> void registerDraggableStackProvider(DraggableStackProvider<T> var1);

    default public <T extends Screen> void registerDraggableStackVisitor(DraggableStackVisitorWidget visitor) {
        this.registerDraggableStackVisitor(DraggableStackVisitorWidget.toVisitor(visitor));
    }

    default public <T extends Screen> void registerDraggableStackProvider(DraggableStackProviderWidget provider) {
        this.registerDraggableStackProvider(DraggableStackProviderWidget.toProvider(provider));
    }

    default public <T extends Screen> void registerDraggableStackVisitor(double priority, DraggableStackVisitorWidget visitor) {
        this.registerDraggableStackVisitor(DraggableStackVisitorWidget.toVisitor(visitor, priority));
    }

    default public <T extends Screen> void registerDraggableStackProvider(double priority, DraggableStackProviderWidget provider) {
        this.registerDraggableStackProvider(DraggableStackProviderWidget.toProvider(provider, priority));
    }

    public Iterable<DraggableStackProvider<Screen>> getDraggableProviders();

    public Iterable<DraggableStackVisitor<Screen>> getDraggableVisitors();

    public <T extends Screen> Rectangle getScreenBounds(T var1);

    public <T extends Screen> Rectangle getOverlayBounds(DisplayPanelLocation var1, T var2);

    @Nullable
    public <T extends Screen> EntryStack<?> getFocusedStack(T var1, Point var2);

    public ExclusionZones exclusionZones();

    default public <C extends Container, T extends ContainerScreen<C>> void registerContainerClickArea(Rectangle area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerContainerClickArea((T screen) -> area, screenClass, categories);
    }

    public <C extends Container, T extends ContainerScreen<C>> void registerContainerClickArea(SimpleClickArea<T> var1, Class<? extends T> var2, CategoryIdentifier<?> ... var3);

    default public <T extends Screen> void registerClickArea(SimpleClickArea<T> area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerClickArea(screenClass, area.toClickArea(() -> categories));
    }

    public <T extends Screen> void registerClickArea(Class<? extends T> var1, ClickArea<T> var2);

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval
    default public <T extends Screen> Set<CategoryIdentifier<?>> handleClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        List<ClickArea.Result> results = this.evaluateClickArea(screenClass, context);
        Set<CategoryIdentifier<?>> identifiers = results.stream().flatMap(ClickArea.Result::getCategories).collect(Collectors.toSet());
        return identifiers.isEmpty() ? null : identifiers;
    }

    public <T extends Screen> List<ClickArea.Result> evaluateClickArea(Class<T> var1, ClickArea.ClickAreaContext<T> var2);

    @Nullable
    default public <T extends Screen> List<ITextComponent> getClickAreaTooltips(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        List<ITextComponent> tooltips = CollectionUtils.flatMap(this.evaluateClickArea(screenClass, context), result -> {
            ITextComponent[] components = result.getTooltips();
            return components == null ? Collections.emptyList() : Arrays.asList(components);
        });
        return tooltips.isEmpty() ? null : tooltips;
    }

    default public <T extends Screen> boolean executeClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        List<ClickArea.Result> results = this.evaluateClickArea(screenClass, context);
        for (ClickArea.Result result : results) {
            if (!result.execute()) continue;
            return true;
        }
        Set<CategoryIdentifier<?>> categories = results.stream().flatMap(ClickArea.Result::getCategories).collect(Collectors.toSet());
        if (!categories.isEmpty()) {
            ViewSearchBuilder.builder().addCategories(categories).open();
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return false;
    }
}

