/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.type;

import java.util.Collection;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface EntryDefinition<T> {
    public Class<T> getValueType();

    public EntryType<T> getType();

    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<T> getRenderer();

    @Nullable
    public ResourceLocation getIdentifier(EntryStack<T> var1, T var2);

    @Nullable
    default public String getContainingNamespace(EntryStack<T> entry, T value) {
        ResourceLocation identifier = this.getIdentifier(entry, value);
        if (identifier == null) {
            return null;
        }
        return identifier.func_110624_b();
    }

    public boolean isEmpty(EntryStack<T> var1, T var2);

    public T copy(EntryStack<T> var1, T var2);

    public T normalize(EntryStack<T> var1, T var2);

    default public T wildcard(EntryStack<T> entry, T value) {
        return this.normalize(entry, value);
    }

    @Nullable
    default public ItemStack cheatsAs(EntryStack<T> entry, T value) {
        return null;
    }

    public long hash(EntryStack<T> var1, T var2, ComparisonContext var3);

    public boolean equals(T var1, T var2, ComparisonContext var3);

    @Nullable
    public EntrySerializer<T> getSerializer();

    public ITextComponent asFormattedText(EntryStack<T> var1, T var2);

    public Collection<ResourceLocation> getTagsFor(ITagCollectionSupplier var1, EntryStack<T> var2, T var3);

    @ApiStatus.NonExtendable
    default public <O> EntryDefinition<O> cast() {
        return this;
    }

    default public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<T> entry) {
        category.func_189529_a("Entry definition class name", () -> this.getClass().getCanonicalName());
    }
}

