/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.gui.modules.AbstractMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class SubMenuEntry
extends AbstractMenuEntry {
    public final ITextComponent text;
    private int textWidth = -69;
    protected List<MenuEntry> entries;
    protected Menu childMenu;

    public SubMenuEntry(ITextComponent text) {
        this(text, Collections.emptyList());
    }

    public SubMenuEntry(ITextComponent text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubMenuEntry(ITextComponent text, List<MenuEntry> entries) {
        this.text = (ITextComponent)MoreObjects.firstNonNull((Object)text, (Object)ImmutableTextComponent.EMPTY);
        this.entries = entries;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.func_238414_a_((ITextProperties)this.text));
        }
        return this.textWidth;
    }

    public Menu getChildMenu() {
        if (this.childMenu == null) {
            this.childMenu = new Menu(new Rectangle(this.getParent().getBounds().x + 1, this.getY() - 1, this.getParent().getBounds().width - 2, this.getEntryHeight() - 2), this.entries, false);
        }
        return this.childMenu;
    }

    @Override
    public int getEntryWidth() {
        return 12 + this.getTextWidth() + 4;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    public void func_230430_a_(MatrixStack poses, int mouseX, int mouseY, float delta) {
        this.renderBackground(poses, this.getX(), this.getY(), this.getWidth(), this.getEntryHeight());
        if (this.isSelected() && !this.entries.isEmpty()) {
            Menu menu = this.getChildMenu();
            Rectangle menuStart = new Rectangle(this.getParent().getBounds().x, this.getY(), this.getParent().getBounds().width, this.getEntryHeight());
            int fullWidth = Minecraft.func_71410_x().field_71462_r.field_230708_k_;
            int fullHeight = Minecraft.func_71410_x().field_71462_r.field_230709_l_;
            boolean facingRight = this.getParent().facingRight;
            int menuWidth = menu.getMaxEntryWidth() + 2 + (menu.hasScrollBar() ? 6 : 0);
            if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
                facingRight = false;
            } else if (!facingRight && menuStart.x < menuWidth + 10) {
                facingRight = true;
            }
            boolean facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
            menu.menuStartPoint.y = facingDownwards ? menuStart.y - 1 : menuStart.getMaxY() - (menu.scrolling.getMaxScrollHeight() + 1);
            menu.menuStartPoint.x = facingRight ? menuStart.getMaxX() : menuStart.x - (menu.getMaxEntryWidth() + 2 + (menu.scrolling.getMaxScrollHeight() > menu.getInnerHeight(menu.menuStartPoint.y) ? 6 : 0));
            ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
            ScissorsHandler.INSTANCE.clearScissors();
            menu.func_230430_a_(poses, mouseX, mouseY, delta);
            for (Rectangle area : areas) {
                ScissorsHandler.INSTANCE.scissor(area);
            }
        }
        this.font.func_243248_b(poses, this.text, (float)(this.getX() + 2), (float)(this.getY() + 2), this.isSelected() ? 0xFFFFFF : 0x888888);
        if (!this.entries.isEmpty()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TabWidget.CHEST_GUI_TEXTURE);
            this.func_238474_b_(poses, this.getX() + this.getWidth() - 15, this.getY() - 2, 0, 28, 18, 18);
        }
    }

    protected void renderBackground(MatrixStack poses, int x, int y, int width, int height) {
        if (this.isSelected()) {
            SubMenuEntry.func_238467_a_((MatrixStack)poses, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-12237499);
        }
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        if (this.childMenu != null && !this.childMenu.func_231039_at__().isEmpty() && this.isSelected()) {
            return this.childMenu.containsMouse(mouseX, mouseY);
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return this.childMenu != null && !this.childMenu.func_231039_at__().isEmpty() && this.isSelected() && this.childMenu.func_231043_a_(mouseX, mouseY, amount);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        if (this.childMenu != null && !this.childMenu.func_231039_at__().isEmpty() && this.isSelected()) {
            return Collections.singletonList(this.childMenu);
        }
        return Collections.emptyList();
    }
}

