/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.DraggableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultDisplayChoosePageWidget
extends DraggableWidget {
    private int currentPage;
    private int maxPage;
    private Rectangle bounds;
    private Rectangle grabBounds;
    private Rectangle dragBounds;
    private List<Widget> widgets;
    private IntConsumer callback;
    private TextFieldWidget textFieldWidget;
    private Panel base1;
    private Panel base2;
    private Button btnDone;

    public DefaultDisplayChoosePageWidget(IntConsumer callback, int currentPage, int maxPage) {
        super(DefaultDisplayChoosePageWidget.getPointFromConfig());
        this.callback = callback;
        this.currentPage = currentPage;
        this.maxPage = maxPage;
        this.initWidgets(this.getMidPoint());
    }

    private static Point getPointFromConfig() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        return new Point((double)window.func_198107_o() * 0.5, (double)window.func_198087_p() * 0.5);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getGrabBounds() {
        return this.grabBounds;
    }

    @Override
    public Rectangle getDragBounds() {
        return this.dragBounds;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.getBounds().contains(mouseX, mouseY) || new Rectangle(this.bounds.x + this.bounds.width - 50, this.bounds.y + this.bounds.height - 3, 50, 36).contains(mouseX, mouseY);
    }

    @Override
    public void updateWidgets(Point midPoint) {
        this.bounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 40);
        this.grabBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 16);
        this.dragBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 70);
        this.base1.getBounds().setLocation(this.bounds.x + this.bounds.width - 50, this.bounds.y + this.bounds.height - 6);
        this.base2.getBounds().setBounds(this.bounds);
        this.textFieldWidget.getBounds().setLocation(this.bounds.x + 7, this.bounds.y + 16);
        this.btnDone.getBounds().setLocation(this.bounds.x + this.bounds.width - 45, this.bounds.y + this.bounds.height + 3);
    }

    @Override
    protected void initWidgets(Point midPoint) {
        this.bounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 40);
        this.grabBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 16);
        this.dragBounds = new Rectangle(midPoint.x - 50, midPoint.y - 20, 100, 70);
        this.widgets = Lists.newArrayList();
        this.base1 = Widgets.createCategoryBase(new Rectangle(this.bounds.x + this.bounds.width - 50, this.bounds.y + this.bounds.height - 6, 50, 36));
        this.widgets.add(this.base1);
        this.base2 = Widgets.createCategoryBase(this.bounds);
        this.widgets.add(this.base2);
        this.widgets.add(new Widget(){
            private TranslationTextComponent text = new TranslationTextComponent("text.rei.choose_page");

            public List<Widget> func_231039_at__() {
                return Collections.emptyList();
            }

            public void func_230430_a_(MatrixStack matrices, int i, int i1, float v) {
                this.font.func_238422_b_(matrices, this.text.func_241878_f(), (float)(((DefaultDisplayChoosePageWidget)DefaultDisplayChoosePageWidget.this).bounds.x + 5), (float)(((DefaultDisplayChoosePageWidget)DefaultDisplayChoosePageWidget.this).bounds.y + 5), REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -12566464);
                String endString = String.format(" /%d", DefaultDisplayChoosePageWidget.this.maxPage);
                int width = this.font.func_78256_a(endString);
                this.font.func_238421_b_(matrices, endString, (float)(((DefaultDisplayChoosePageWidget)DefaultDisplayChoosePageWidget.this).bounds.x + ((DefaultDisplayChoosePageWidget)DefaultDisplayChoosePageWidget.this).bounds.width - 5 - width), (float)(((DefaultDisplayChoosePageWidget)DefaultDisplayChoosePageWidget.this).bounds.y + 22), REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -12566464);
            }
        });
        String endString = String.format(" /%d", this.maxPage);
        int width = this.font.func_78256_a(endString);
        this.textFieldWidget = new TextFieldWidget(this.bounds.x + 7, this.bounds.y + 16, this.bounds.width - width - 12, 18);
        this.widgets.add(this.textFieldWidget);
        this.textFieldWidget.setMaxLength(10000);
        this.textFieldWidget.stripInvalid = s -> {
            StringBuilder stringBuilder_1 = new StringBuilder();
            char[] var2 = s.toCharArray();
            int var3 = var2.length;
            for (char char_1 : var2) {
                if (!Character.isDigit(char_1)) continue;
                stringBuilder_1.append(char_1);
            }
            return stringBuilder_1.toString();
        };
        this.textFieldWidget.setText(String.valueOf(this.currentPage + 1));
        this.btnDone = Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 45, this.bounds.y + this.bounds.height + 3, 40, 20), (ITextComponent)new TranslationTextComponent("gui.done")).onClick(button -> {
            this.callback.accept(MathHelper.func_76125_a((int)(this.getIntFromString(this.textFieldWidget.getText()).orElse(0) - 1), (int)0, (int)(this.maxPage - 1)));
            ScreenOverlayImpl.getInstance().choosePageWidget = null;
        });
        this.widgets.add(this.btnDone);
        this.textFieldWidget.setFocused(true);
    }

    @Override
    public Point processMidPoint(Point midPoint, Point mouse, Point startPoint, MainWindow window, int relateX, int relateY) {
        return new Point(MathHelper.func_76125_a((int)(mouse.x - relateX), (int)(this.getDragBounds().width / 2), (int)(window.func_198107_o() - this.getDragBounds().width / 2)), MathHelper.func_76125_a((int)(mouse.y - relateY), (int)20, (int)(window.func_198087_p() - 50)));
    }

    public List<Widget> func_231039_at__() {
        return this.widgets;
    }

    public void func_230430_a_(MatrixStack matrices, int i, int i1, float v) {
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 0.0, 800.0);
        for (Widget widget : this.widgets) {
            widget.func_230430_a_(matrices, i, i1, v);
        }
        matrices.func_227865_b_();
    }

    public boolean func_231042_a_(char char_1, int int_1) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231042_a_(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (int_1 == 335 || int_1 == 257) {
            this.callback.accept(MathHelper.func_76125_a((int)(this.getIntFromString(this.textFieldWidget.getText()).orElse(0) - 1), (int)0, (int)(this.maxPage - 1)));
            ScreenOverlayImpl.getInstance().choosePageWidget = null;
            return true;
        }
        for (Widget widget : this.widgets) {
            if (!widget.func_231046_a_(int_1, int_2, int_3)) continue;
            return true;
        }
        return false;
    }

    public Optional<Integer> getIntFromString(String s) {
        try {
            return Optional.of(Integer.valueOf(s));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Override
    public void onMouseReleaseMidPoint(Point midPoint) {
    }
}

