/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.architectury.utils.GameInstance;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;

public class RecipeManagerContextImpl<P extends REIPlugin<?>>
implements RecipeManagerContext<P> {
    private static final Comparator<IRecipe<?>> RECIPE_COMPARATOR = Comparator.comparing(o -> o.func_199560_c().func_110624_b()).thenComparing(o -> o.func_199560_c().func_110623_a());
    private final Supplier<RecipeManager> recipeManager;
    private List<IRecipe<?>> sortedRecipes = null;

    public RecipeManagerContextImpl(Supplier<RecipeManager> recipeManager) {
        this.recipeManager = recipeManager;
    }

    public static Supplier<RecipeManager> supplier() {
        return () -> (RecipeManager)EnvExecutor.getEnvSpecific(() -> () -> Minecraft.func_71410_x().func_147114_u().func_199526_e(), () -> () -> GameInstance.getServer().func_199529_aN());
    }

    @Override
    public List<IRecipe<?>> getAllSortedRecipes() {
        if (this.sortedRecipes == null) {
            this.sortedRecipes = this.getRecipeManager().func_199510_b().parallelStream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.sortedRecipes);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.recipeManager.get();
    }

    @Override
    public void startReload() {
        this.sortedRecipes = null;
    }
}

