/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.imitator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import me.shedaniel.rei.jeicompat.imitator.JEIFurnaceVariantCategory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class JEIAbstractCookingCategory<T extends AbstractCookingRecipe>
extends JEIFurnaceVariantCategory<T> {
    private final IDrawable background;
    private final int regularCookTime;
    private final IDrawable icon;
    private final ITextComponent localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public JEIAbstractCookingCategory(final IGuiHelper guiHelper, Block icon, String translationKey, int regularCookTime) {
        super(guiHelper);
        this.background = guiHelper.createDrawable(new ResourceLocation("jei:textures/gui/gui_vanilla.png"), 0, 114, 82, 54);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableIngredient(new ItemStack((IItemProvider)icon));
        this.localizedName = new TranslationTextComponent(translationKey);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(new ResourceLocation("jei:textures/gui/gui_vanilla.png"), 82, 128, 24, 17).buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getArrow(T recipe) {
        int cookTime = recipe.func_222137_e();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setIngredients(T recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List<Ingredient>)recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, recipe.func_77571_b());
    }

    @Override
    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(matrixStack, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(matrixStack, 24, 18);
        this.drawExperience(recipe, matrixStack, 0);
        this.drawCookTime(recipe, matrixStack, 45);
    }

    protected void drawExperience(T recipe, MatrixStack matrixStack, int y) {
        float experience = recipe.func_222138_b();
        if (experience > 0.0f) {
            TranslationTextComponent experienceString = new TranslationTextComponent("gui.jei.category.smelting.experience", new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)experienceString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)experienceString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawCookTime(T recipe, MatrixStack matrixStack, int y) {
        int cookTime = recipe.func_222137_e();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category.smelting.time.seconds", new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    @Override
    @Deprecated
    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    @Override
    public ITextComponent getTitleAsTextComponent() {
        return this.localizedName;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, T recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }

    @Override
    public boolean isHandled(T recipe) {
        return !recipe.func_192399_d();
    }
}

