/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIUnwrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class JEIExtendableRecipeCategory<T, D extends Display, W extends IRecipeCategoryExtension>
extends JEIUnwrappedCategory<T, D>
implements IExtendableRecipeCategory<T, W> {
    private final JEIPluginDetector.JEIPluginWrapper wrapper;

    public JEIExtendableRecipeCategory(JEIPluginDetector.JEIPluginWrapper wrapper, DisplayCategory<D> backingCategory) {
        super(backingCategory);
        this.wrapper = wrapper;
    }

    @Override
    public <R extends T> void addCategoryExtension(Class<? extends R> recipeClass, Function<R, ? extends W> extensionFactory) {
        this.addCategoryExtension(recipeClass, $ -> true, extensionFactory);
    }

    @Override
    public <R extends T> void addCategoryExtension(Class<? extends R> recipeClass, Predicate<R> extensionFilter, Function<R, ? extends W> extensionFactory) {
        CategoryRegistry.getInstance().configure(this.getBackingCategory().getCategoryIdentifier().cast(), config -> config.registerExtension((display, category, lastView) -> {
            Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
            if (recipeClass.isInstance(origin) && extensionFilter.test(origin)) {
                return new ExtendedCategoryView(this, origin, lastView, category, (IRecipeCategoryExtension)extensionFactory.apply(origin));
            }
            return lastView;
        }));
    }

    private static class ExtendedCategoryView<R>
    implements DisplayCategoryView<D> {
        private final R origin;
        private final DisplayCategoryView<D> lastView;
        private final DisplayCategory<D> category;
        private final W extension;
        final /* synthetic */ JEIExtendableRecipeCategory this$0;

        public ExtendedCategoryView(R origin, DisplayCategoryView<D> lastView, DisplayCategory<D> category, W extension) {
            this.this$0 = var1_1;
            this.origin = origin;
            this.lastView = lastView;
            this.category = category;
            this.extension = extension;
        }

        @Override
        public DisplayRenderer getDisplayRenderer(D display) {
            return this.lastView.getDisplayRenderer(display);
        }

        @Override
        public List<Widget> setupDisplay(D display, final Rectangle bounds) {
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            if (this.category instanceof JEIWrappedCategory) {
                IIngredients ingredients = JEIWrappedDisplay.createIngredients();
                this.extension.setIngredients(ingredients);
                widgets.addAll(JEIWrappedCategory.setupDisplay(((JEIWrappedCategory)this.category).getBackingCategory(), this.origin, ingredients, bounds, ((JEIWrappedCategory)this.category).background));
            } else {
                widgets.addAll(this.lastView.setupDisplay(display, bounds));
            }
            widgets.add(new WidgetWithBounds(){

                @Override
                public Rectangle getBounds() {
                    return bounds;
                }

                public void func_230430_a_(MatrixStack arg, int i, int j, float f) {
                    Tooltip tooltip;
                    arg.func_227860_a_();
                    arg.func_227861_a_((double)(bounds.x + 4), (double)(bounds.y + 4), (double)this.getZ());
                    ExtendedCategoryView.this.extension.drawInfo(bounds.width, bounds.height, arg, i - bounds.x, j - bounds.y);
                    arg.func_227865_b_();
                    Point mouse = PointHelper.ofMouse();
                    if (this.containsMouse(mouse) && (tooltip = this.getTooltip(mouse)) != null) {
                        tooltip.queue();
                    }
                }

                @Override
                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    List<ITextComponent> strings = ExtendedCategoryView.this.extension.getTooltipStrings(mouse.x - bounds.x, mouse.y - bounds.y);
                    if (strings.isEmpty()) {
                        return null;
                    }
                    return Tooltip.create(mouse, strings);
                }

                public List<? extends IGuiEventListener> func_231039_at__() {
                    return Collections.emptyList();
                }

                public boolean func_231044_a_(double d, double e, int i) {
                    return ExtendedCategoryView.this.extension.handleClick(d - (double)bounds.x, e - (double)bounds.y, i) || super.func_231044_a_(d, e, i);
                }
            });
            return widgets;
        }
    }
}

