/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Objects;
import me.shedaniel.architectury.hooks.forge.FluidStackHooksForge;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public enum JEISubtypeRegistration implements ISubtypeRegistration
{
    INSTANCE;


    @Override
    public void registerSubtypeInterpreter(@NotNull Item item, @NotNull ISubtypeInterpreter interpreter) {
        this.registerSubtypeInterpreter(item, (IIngredientSubtypeInterpreter<ItemStack>)interpreter);
    }

    @Override
    public void registerSubtypeInterpreter(@NotNull Item item, @NotNull IIngredientSubtypeInterpreter<ItemStack> interpreter) {
        if (interpreter == null) {
            return;
        }
        ItemComparatorRegistry.getInstance().register(JEISubtypeRegistration.wrapItemComparator(interpreter), item);
    }

    @Override
    public void registerSubtypeInterpreter(@NotNull Fluid fluid, @NotNull IIngredientSubtypeInterpreter<FluidStack> interpreter) {
        if (interpreter == null) {
            return;
        }
        FluidComparatorRegistry.getInstance().register(JEISubtypeRegistration.wrapFluidComparator(interpreter), fluid);
    }

    @Override
    public void useNbtForSubtypes(Item ... items) {
        ItemComparatorRegistry.getInstance().registerNbt(items);
    }

    @Override
    public void useNbtForSubtypes(Fluid ... fluids) {
        FluidComparatorRegistry.getInstance().registerNbt(fluids);
    }

    @Override
    public boolean hasSubtypeInterpreter(@NotNull ItemStack itemStack) {
        return ItemComparatorRegistry.getInstance().containsComparator(itemStack.func_77973_b());
    }

    @Override
    public boolean hasSubtypeInterpreter(@NotNull FluidStack fluidStack) {
        return FluidComparatorRegistry.getInstance().containsComparator(fluidStack.getFluid());
    }

    private static EntryComparator<ItemStack> wrapItemComparator(IIngredientSubtypeInterpreter<ItemStack> interpreter) {
        return (context, stack) -> {
            try {
                return Objects.hashCode(interpreter.apply((ItemStack)stack, JEIPluginDetector.wrapContext(context)));
            }
            catch (NullPointerException e) {
                return 0L;
            }
        };
    }

    private static EntryComparator<me.shedaniel.architectury.fluid.FluidStack> wrapFluidComparator(IIngredientSubtypeInterpreter<FluidStack> interpreter) {
        return (context, stack) -> {
            try {
                return Objects.hashCode(interpreter.apply(FluidStackHooksForge.toForge((me.shedaniel.architectury.fluid.FluidStack)stack), JEIPluginDetector.wrapContext(context)));
            }
            catch (NullPointerException e) {
                return 0L;
            }
        };
    }
}

