/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JEIWrappedDisplay<T>
implements Display {
    private final JEIWrappedCategory<T> backingCategory;
    private final T backingRecipe;
    private final List<EntryIngredient> compiledInput = new ArrayList<EntryIngredient>();
    private final List<EntryIngredient> compiledOutputs = new ArrayList<EntryIngredient>();
    private final IIngredients ingredients;

    public JEIWrappedDisplay(JEIWrappedCategory<T> backingCategory, T backingRecipe) {
        this.backingCategory = backingCategory;
        this.backingRecipe = backingRecipe;
        this.ingredients = JEIWrappedDisplay.createIngredients();
        backingCategory.getBackingCategory().setIngredients(this.backingRecipe, this.ingredients);
        JEIWrappedDisplay.compileIngredients(this.ingredients, this.compiledInput, this.compiledOutputs);
    }

    public static IIngredients createIngredients() {
        return new JEIIngredients();
    }

    public static void compileIngredients(IIngredients ingredients, List<EntryIngredient> compiledInput, List<EntryIngredient> compiledOutputs) {
        for (Map.Entry<IIngredientType<?>, List<List<?>>> entry : ((JEIIngredients)ingredients).inputs.entrySet()) {
            for (List<?> slot : entry.getValue()) {
                compiledInput.add(JEIPluginDetector.unwrapList(entry.getKey(), slot));
            }
        }
        for (Map.Entry<IIngredientType<?>, List<List<?>>> entry : ((JEIIngredients)ingredients).outputs.entrySet()) {
            for (List<?> slot : entry.getValue()) {
                compiledOutputs.add(JEIPluginDetector.unwrapList(entry.getKey(), slot));
            }
        }
    }

    public IIngredients getIngredients() {
        return this.ingredients;
    }

    public JEIWrappedCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    public T getBackingRecipe() {
        return this.backingRecipe;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.backingCategory.getCategoryIdentifier();
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.compiledInput;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.compiledOutputs;
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        if (this.backingRecipe instanceof IRecipe) {
            return Optional.ofNullable(((IRecipe)this.backingRecipe).func_199560_c());
        }
        return Optional.empty();
    }

    private static class JEIIngredients
    implements IIngredients {
        Map<IIngredientType<?>, List<? extends List<?>>> inputs = new HashMap();
        Map<IIngredientType<?>, List<? extends List<?>>> outputs = new HashMap();

        private JEIIngredients() {
        }

        @Override
        public void setInputIngredients(@NotNull List<Ingredient> inputs) {
            this.setInputLists((IIngredientType)VanillaTypes.ITEM, CollectionUtils.map(inputs, ingredient -> Arrays.asList(ingredient.func_193365_a())));
        }

        public <R> void setInput(@NotNull IIngredientType<R> ingredientType, @NotNull R input) {
            List ingredient = this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
            ingredient.add(Collections.singletonList(input));
        }

        public <R> void setInputs(@NotNull IIngredientType<R> ingredientType, @NotNull List<R> input) {
            List ingredient = this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
            ingredient.addAll(CollectionUtils.map(input, Collections::singletonList));
        }

        public <R> void setInputLists(@NotNull IIngredientType<R> ingredientType, @NotNull List<List<R>> input) {
            List ingredient = this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
            ingredient.addAll(input);
        }

        public <R> void setOutput(@NotNull IIngredientType<R> ingredientType, @NotNull R output) {
            List ingredient = this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
            ingredient.add(Collections.singletonList(output));
        }

        public <R> void setOutputs(@NotNull IIngredientType<R> ingredientType, @NotNull List<R> output) {
            List ingredient = this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
            ingredient.addAll(CollectionUtils.map(output, Collections::singletonList));
        }

        public <R> void setOutputLists(@NotNull IIngredientType<R> ingredientType, @NotNull List<List<R>> output) {
            List ingredient = this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
            ingredient.addAll(output);
        }

        @NotNull
        public <R> List<List<R>> getInputs(@NotNull IIngredientType<R> ingredientType) {
            return this.inputs.getOrDefault(ingredientType, Collections.emptyList());
        }

        @NotNull
        public <R> List<List<R>> getOutputs(@NotNull IIngredientType<R> ingredientType) {
            return this.outputs.getOrDefault(ingredientType, Collections.emptyList());
        }
    }
}

