/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.init.BSModProcessors;
import com.yungnickyoung.minecraft.betterstrongholds.util.Banner;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class BannerProcessor
extends StructureProcessor {
    public static final BannerProcessor INSTANCE = new BannerProcessor();
    public static final Codec<BannerProcessor> CODEC = Codec.unit(() -> INSTANCE);
    public static final Banner ENDERMAN_WALL_BANNER = new Banner.Builder().blockState(Blocks.field_196847_hl.func_176223_P()).pattern("ss", 0).pattern("ts", 15).pattern("hhb", 15).pattern("bo", 15).pattern("ms", 15).pattern("cs", 15).build();
    public static final Banner WITHER_WALL_BANNER = new Banner.Builder().blockState(Blocks.field_196873_hy.func_176223_P()).pattern("bs", 7).pattern("cs", 15).pattern("hh", 7).pattern("cre", 15).pattern("sku", 15).build();
    public static final Banner PORTAL_WALL_BANNER = new Banner.Builder().blockState(Blocks.field_196863_ht.func_176223_P()).pattern("ss", 2).pattern("bri", 10).pattern("cbo", 2).pattern("bo", 15).build();
    public static final List<Banner> WALL_BANNERS = Lists.newArrayList((Object[])new Banner[]{ENDERMAN_WALL_BANNER, WITHER_WALL_BANNER, PORTAL_WALL_BANNER});

    @ParametersAreNonnullByDefault
    public Template.BlockInfo process(IWorldReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, Template.BlockInfo blockInfoLocal, Template.BlockInfo blockInfoGlobal, PlacementSettings structurePlacementData, @Nullable Template template) {
        if (blockInfoGlobal.field_186243_b.func_177230_c() instanceof AbstractBannerBlock && blockInfoGlobal.field_186243_b.func_177230_c() == Blocks.field_196857_hq && (blockInfoGlobal.field_186244_c.func_74781_a("Patterns") == null || blockInfoGlobal.field_186244_c.func_150295_c("Patterns", 10).size() == 0)) {
            Banner banner = this.getRandomBanner(structurePlacementData.func_189947_a(blockInfoGlobal.field_186242_a));
            Direction facing = (Direction)blockInfoGlobal.field_186243_b.func_177229_b((Property)BlockStateProperties.field_208157_J);
            BlockState newState = (BlockState)banner.getState().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing);
            CompoundNBT newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new Template.BlockInfo(blockInfoGlobal.field_186242_a, newState, newNBT);
        }
        return blockInfoGlobal;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BSModProcessors.BANNER_PROCESSOR;
    }

    private Banner getRandomBanner(Random random) {
        return WALL_BANNERS.get(random.nextInt(WALL_BANNERS.size()));
    }

    private CompoundNBT copyNBT(CompoundNBT other) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_197643_a(other);
        return nbt;
    }
}

