/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import team.chisel.client.ClientProxy;
import team.chisel.common.block.TileAutoChisel;

public class MessageAutochiselFX {
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final ItemStack chisel;
    @Nonnull
    private final BlockState state;

    public void encode(PacketBuffer buf) {
        buf.writeLong(this.pos.func_218275_a());
        buf.func_150788_a(this.chisel);
        buf.writeInt(Block.func_196246_j((BlockState)this.state));
    }

    public static MessageAutochiselFX decode(PacketBuffer buf) {
        return new MessageAutochiselFX(BlockPos.func_218283_e((long)buf.readLong()), buf.func_150791_c(), Block.func_196257_b((int)buf.readInt()));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            World world = ClientProxy.getClientWorld();
            if (world.func_175667_e(this.pos) && (te = world.func_175625_s(this.pos)) instanceof TileAutoChisel) {
                ((TileAutoChisel)te).spawnCompletionFX(ClientProxy.getClientPlayer(), this.chisel, this.state);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public MessageAutochiselFX(@Nonnull BlockPos pos, @Nonnull ItemStack chisel, @Nonnull BlockState state) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (chisel == null) {
            throw new NullPointerException("chisel is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.pos = pos;
        this.chisel = chisel;
        this.state = state;
    }
}

