/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.carving;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IVariationRegistry;
import team.chisel.common.util.ItemSorter;

@ParametersAreNonnullByDefault
public class CarvingVariationRegistry
implements IVariationRegistry {
    private final Map<ResourceLocation, ICarvingGroup> groups = new HashMap<ResourceLocation, ICarvingGroup>();

    @Override
    public Optional<ICarvingGroup> getGroup(ResourceLocation id) {
        return Optional.ofNullable(this.groups.get(id));
    }

    @Override
    public Optional<ICarvingGroup> getGroup(Item item) {
        return this.groups.values().stream().filter(g -> g.getItemTag().func_230235_a_((Object)item)).findFirst();
    }

    @Override
    public Optional<ICarvingGroup> getGroup(Block block) {
        return this.groups.values().stream().filter(g -> g.getBlockTag().map(tag -> tag.func_230235_a_((Object)block)).orElse(false)).findFirst();
    }

    @Override
    public Optional<ICarvingVariation> getVariation(final Block block) {
        return this.getGroup(block).map(g -> new ICarvingVariation((ICarvingGroup)g){
            final /* synthetic */ ICarvingGroup val$g;
            {
                this.val$g = iCarvingGroup;
            }

            @Override
            public Item getItem() {
                return block.func_199767_j();
            }

            @Override
            public ICarvingGroup getGroup() {
                return this.val$g;
            }

            @Override
            public Block getBlock() {
                return block;
            }
        });
    }

    @Override
    public Optional<ICarvingVariation> getVariation(final Item item) {
        return this.getGroup(item).map(g -> new ICarvingVariation((ICarvingGroup)g){
            final /* synthetic */ ICarvingGroup val$g;
            {
                this.val$g = iCarvingGroup;
            }

            @Override
            public Item getItem() {
                return item;
            }

            @Override
            public ICarvingGroup getGroup() {
                return this.val$g;
            }

            @Override
            public Block getBlock() {
                return Block.func_149634_a((Item)item);
            }
        });
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ItemStack chiseled) {
        return this.getGroup(chiseled.func_77973_b()).map(this::getItemsForChiseling).orElse(Collections.emptyList());
    }

    @Override
    public List<ItemStack> getItemsForChiseling(ResourceLocation groupId) {
        ICarvingGroup group = this.groups.get(groupId);
        return group == null ? Collections.emptyList() : this.getItemsForChiseling(group);
    }

    private List<ItemStack> getItemsForChiseling(ICarvingGroup group) {
        return group.getItemTag().func_230236_b_().stream().map(ItemStack::new).sorted(Comparator.comparing(ItemStack::func_77973_b, ItemSorter.variantOrder())).collect(Collectors.toList());
    }

    @Override
    public List<ICarvingGroup> getGroups() {
        return ImmutableList.copyOf(this.groups.values());
    }

    @Override
    public void addGroup(ICarvingGroup group) {
        this.groups.put(group.getId(), group);
    }

    @Override
    public ICarvingGroup removeGroup(ResourceLocation groupName) {
        return this.groups.remove(groupName);
    }
}

