/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptReader;
import tschipp.carryon.network.client.ScriptReloadPacket;

@Mod.EventBusSubscriber(modid="carryon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScriptReloadListener
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ScriptReloadListener() {
        super(GSON, "carryon/scripts");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager manager, IProfiler profiler) {
        ScriptReader.OVERRIDES.clear();
        objects.forEach((path, jsonElem) -> {
            CarryOnOverride override = new CarryOnOverride((JsonElement)jsonElem, (ResourceLocation)path);
            if (!override.isInvalid) {
                ScriptReader.OVERRIDES.put(override.hashCode(), override);
            }
        });
        if (EffectiveSide.get().isServer() && ServerLifecycleHooks.getCurrentServer() != null) {
            CarryOn.network.send(PacketDistributor.ALL.noArg(), (Object)new ScriptReloadPacket(ScriptReader.OVERRIDES.values()));
        }
    }

    @SubscribeEvent
    public static void onDatapackRegister(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ScriptReloadListener());
    }
}

