/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXX;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReadProgressListener;
import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReader;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.SoftReference;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;

final class JFXXThumbnailReader
extends ThumbnailReader {
    private final ImageReader reader;
    private final JFXX segment;
    private transient SoftReference<BufferedImage> cachedThumbnail;

    JFXXThumbnailReader(ThumbnailReadProgressListener thumbnailReadProgressListener, ImageReader imageReader, int n, int n2, JFXX jFXX) {
        super(thumbnailReadProgressListener, n, n2);
        this.reader = Validate.notNull(imageReader);
        this.segment = jFXX;
    }

    @Override
    public BufferedImage read() throws IOException {
        BufferedImage bufferedImage;
        this.processThumbnailStarted();
        switch (this.segment.extensionCode) {
            case 16: {
                bufferedImage = this.readJPEGCached(true);
                break;
            }
            case 17: {
                bufferedImage = this.readIndexed();
                break;
            }
            case 19: {
                bufferedImage = this.readRGB();
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported JFXX extension code: %d", this.segment.extensionCode));
            }
        }
        this.processThumbnailProgress(100.0f);
        this.processThumbnailComplete();
        return bufferedImage;
    }

    IIOMetadata readMetadata() throws IOException {
        try (ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(this.segment.thumbnail);){
            this.reader.setInput(byteArrayImageInputStream);
            IIOMetadata iIOMetadata = this.reader.getImageMetadata(0);
            return iIOMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readJPEGCached(boolean bl) throws IOException {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = bufferedImage = this.cachedThumbnail != null ? this.cachedThumbnail.get() : null;
        if (bufferedImage == null) {
            try (ByteArrayImageInputStream byteArrayImageInputStream = new ByteArrayImageInputStream(this.segment.thumbnail);){
                bufferedImage = JFXXThumbnailReader.readJPEGThumbnail(this.reader, byteArrayImageInputStream);
            }
        }
        this.cachedThumbnail = bl ? null : new SoftReference<BufferedImage>(bufferedImage);
        return bufferedImage;
    }

    @Override
    public int getWidth() throws IOException {
        switch (this.segment.extensionCode) {
            case 17: 
            case 19: {
                return this.segment.thumbnail[0] & 0xFF;
            }
            case 16: {
                return this.readJPEGCached(false).getWidth();
            }
        }
        throw new IIOException(String.format("Unsupported JFXX extension code: %d", this.segment.extensionCode));
    }

    @Override
    public int getHeight() throws IOException {
        switch (this.segment.extensionCode) {
            case 17: 
            case 19: {
                return this.segment.thumbnail[1] & 0xFF;
            }
            case 16: {
                return this.readJPEGCached(false).getHeight();
            }
        }
        throw new IIOException(String.format("Unsupported JFXX extension code: %d", this.segment.extensionCode));
    }

    private BufferedImage readIndexed() {
        int n = this.segment.thumbnail[0] & 0xFF;
        int n2 = this.segment.thumbnail[1] & 0xFF;
        int[] nArray = new int[256];
        for (int j = 0; j < nArray.length; ++j) {
            nArray[j] = (this.segment.thumbnail[3 * j + 2] & 0xFF) << 16 | (this.segment.thumbnail[3 * j + 3] & 0xFF) << 8 | this.segment.thumbnail[3 * j + 4] & 0xFF;
        }
        InverseColorMapIndexColorModel inverseColorMapIndexColorModel = new InverseColorMapIndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        DataBufferByte dataBufferByte = new DataBufferByte(this.segment.thumbnail, this.segment.thumbnail.length - 770, 770);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n, n2, 8, null);
        return new BufferedImage(inverseColorMapIndexColorModel, writableRaster, inverseColorMapIndexColorModel.isAlphaPremultiplied(), null);
    }

    private BufferedImage readRGB() {
        int n = this.segment.thumbnail[0] & 0xFF;
        int n2 = this.segment.thumbnail[1] & 0xFF;
        return ThumbnailReader.readRawThumbnail(this.segment.thumbnail, this.segment.thumbnail.length - 2, 2, n, n2);
    }
}

