/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.ThumbnailReadProgressListener;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

abstract class ThumbnailReader {
    private final ThumbnailReadProgressListener progressListener;
    protected final int imageIndex;
    protected final int thumbnailIndex;

    protected ThumbnailReader(ThumbnailReadProgressListener thumbnailReadProgressListener, int n, int n2) {
        this.progressListener = thumbnailReadProgressListener != null ? thumbnailReadProgressListener : new NullProgressListener();
        this.imageIndex = n;
        this.thumbnailIndex = n2;
    }

    protected final void processThumbnailStarted() {
        this.progressListener.thumbnailStarted(this.imageIndex, this.thumbnailIndex);
    }

    protected final void processThumbnailProgress(float f2) {
        this.progressListener.thumbnailProgress(f2);
    }

    protected final void processThumbnailComplete() {
        this.progressListener.thumbnailComplete();
    }

    protected static BufferedImage readJPEGThumbnail(ImageReader imageReader, ImageInputStream imageInputStream) throws IOException {
        imageReader.setInput(imageInputStream);
        return imageReader.read(0);
    }

    protected static BufferedImage readRawThumbnail(byte[] byArray, int n, int n2, int n3, int n4) {
        ComponentColorModel componentColorModel;
        WritableRaster writableRaster;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n2);
        if (byArray.length == n3 * n4) {
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3, 1, new int[]{0}, null);
            componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        } else {
            writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3 * 3, 3, new int[]{0, 1, 2}, null);
            componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
        }
        return new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
    }

    public abstract BufferedImage read() throws IOException;

    public abstract int getWidth() throws IOException;

    public abstract int getHeight() throws IOException;

    private static class NullProgressListener
    implements ThumbnailReadProgressListener {
        private NullProgressListener() {
        }

        @Override
        public void thumbnailStarted(int n, int n2) {
        }

        @Override
        public void thumbnailProgress(float f2) {
        }

        @Override
        public void thumbnailComplete() {
        }
    }
}

