/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public final class PICTImageWriter
extends ImageWriterBase {
    private int rowBytes;
    private byte[] scanlineBytes;
    private int scanWidthLeft;

    public PICTImageWriter() {
        this(null);
    }

    protected PICTImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    private void writePICTHeader(RenderedImage renderedImage) throws IOException {
        byte[] byArray = new byte[512];
        this.imageOutput.write(byArray);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(renderedImage.getHeight());
        this.imageOutput.writeShort(renderedImage.getWidth());
        this.imageOutput.writeShort(17);
        this.imageOutput.writeShort(767);
        this.imageOutput.writeShort(3072);
        this.imageOutput.writeInt(-131072);
        this.imageOutput.writeShort(72);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(72);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(renderedImage.getHeight());
        this.imageOutput.writeShort(renderedImage.getWidth());
        this.imageOutput.writeInt(0);
        this.imageOutput.writeShort(30);
        this.imageOutput.writeShort(1);
        this.imageOutput.writeShort(10);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(renderedImage.getHeight());
        this.imageOutput.writeShort(renderedImage.getWidth());
        this.imageOutput.writeShort(154);
        this.imageOutput.writeInt(255);
        this.rowBytes = 4 * renderedImage.getWidth();
        this.imageOutput.writeShort(0x8000 | this.rowBytes);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(renderedImage.getHeight());
        this.imageOutput.writeShort(renderedImage.getWidth());
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(4);
        this.imageOutput.writeInt(0);
        this.imageOutput.writeShort(72);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(72);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(16);
        this.imageOutput.writeShort(32);
        this.imageOutput.writeShort(3);
        this.imageOutput.writeShort(8);
        this.imageOutput.writeInt(0);
        this.imageOutput.writeInt(0);
        this.imageOutput.writeInt(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(renderedImage.getHeight());
        this.imageOutput.writeShort(renderedImage.getWidth());
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(0);
        this.imageOutput.writeShort(renderedImage.getHeight());
        this.imageOutput.writeShort(renderedImage.getWidth());
        this.imageOutput.writeShort(0);
        this.scanlineBytes = new byte[3 * renderedImage.getWidth()];
        this.scanWidthLeft = renderedImage.getWidth();
    }

    private void writePICTData(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(this.scanlineBytes.length / 2);
        int n7 = colorModel.getNumComponents();
        for (int j = 0; j < n4; ++j) {
            this.scanWidthLeft -= n3;
            for (int k = 0; k < n3; ++k) {
                if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().getType() == 5) {
                    this.scanlineBytes[n + k] = byArray[n5 + j * n6 * n7 + n7 * k + n7 - 1];
                    this.scanlineBytes[n + n3 + k] = byArray[n5 + j * n6 * n7 + n7 * k + n7 - 2];
                    this.scanlineBytes[n + 2 * n3 + k] = byArray[n5 + j * n6 * n7 + n7 * k + n7 - 3];
                    continue;
                }
                int n8 = colorModel.getRGB(byArray[n5 + j * n6 + k] & 0xFF);
                this.scanlineBytes[n + k] = (byte)(n8 >> 16 & 0xFF);
                this.scanlineBytes[n + n3 + k] = (byte)(n8 >> 8 & 0xFF);
                this.scanlineBytes[n + 2 * n3 + k] = (byte)(n8 & 0xFF);
            }
            if (this.scanWidthLeft != 0) continue;
            fastByteArrayOutputStream.reset();
            DataOutputStream dataOutputStream = new DataOutputStream(new EncoderStream(fastByteArrayOutputStream, new PackBitsEncoder(), true));
            dataOutputStream.write(this.scanlineBytes);
            if (this.rowBytes > 250) {
                this.imageOutput.writeShort(fastByteArrayOutputStream.size());
            } else {
                this.imageOutput.writeByte(fastByteArrayOutputStream.size());
            }
            OutputStream outputStream = IIOUtil.createStreamAdapter(this.imageOutput);
            ((ByteArrayOutputStream)fastByteArrayOutputStream).writeTo(outputStream);
            outputStream.flush();
            this.scanWidthLeft = n3;
        }
    }

    private void writePICTData(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(this.scanlineBytes.length / 2);
        for (int j = 0; j < n4; ++j) {
            this.scanWidthLeft -= n3;
            for (int k = 0; k < n3; ++k) {
                int n7 = colorModel.getRGB(nArray[n5 + j * n6 + k]);
                this.scanlineBytes[n + k] = (byte)(n7 >> 16 & 0xFF);
                this.scanlineBytes[n + n3 + k] = (byte)(n7 >> 8 & 0xFF);
                this.scanlineBytes[n + 2 * n3 + k] = (byte)(n7 & 0xFF);
            }
            if (this.scanWidthLeft == 0) {
                fastByteArrayOutputStream.reset();
                DataOutputStream dataOutputStream = new DataOutputStream(new EncoderStream(fastByteArrayOutputStream, new PackBitsEncoder(), true));
                dataOutputStream.write(this.scanlineBytes);
                if (this.rowBytes > 250) {
                    this.imageOutput.writeShort(fastByteArrayOutputStream.size());
                } else {
                    this.imageOutput.writeByte(fastByteArrayOutputStream.size());
                }
                OutputStream outputStream = IIOUtil.createStreamAdapter(this.imageOutput);
                ((ByteArrayOutputStream)fastByteArrayOutputStream).writeTo(outputStream);
                outputStream.flush();
                this.scanWidthLeft = n3;
            }
            this.processImageProgress(100.0f * (float)j / (float)n4);
        }
    }

    private void writePICTTrailer() throws IOException {
        long l = this.imageOutput.length();
        if (l == -1L) {
            throw new IIOException("Cannot write trailer without knowing length");
        }
        if ((l & 1L) > 0L) {
            this.imageOutput.writeByte(0);
        }
        this.imageOutput.writeShort(255);
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.assertOutput();
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write raster");
        }
        this.processImageStarted(0);
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        this.writePICTHeader(renderedImage);
        Raster raster = renderedImage instanceof BufferedImage ? ((BufferedImage)renderedImage).getRaster() : renderedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            this.writePICTData(0, 0, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getColorModel(), ((DataBufferByte)dataBuffer).getData(), 0, renderedImage.getWidth());
        } else if (dataBuffer instanceof DataBufferInt) {
            this.writePICTData(0, 0, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getColorModel(), ((DataBufferInt)dataBuffer).getData(), 0, renderedImage.getWidth());
        } else {
            throw new IIOException("DataBuffer type " + dataBuffer.getDataType() + " not supported");
        }
        this.writePICTTrailer();
        this.processImageComplete();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        throw new UnsupportedOperationException("Method getDefaultImageMetadata not implemented");
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        throw new UnsupportedOperationException("Method convertImageMetadata not implemented");
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.print("Reading image.. ");
        BufferedImage bufferedImage = ImageIO.read(new File(stringArray[0]));
        System.out.println("image read");
        System.out.println("image: " + bufferedImage);
        PICTImageWriter pICTImageWriter = new PICTImageWriter(null);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(stringArray[1]));
        ((ImageWriter)pICTImageWriter).setOutput(imageOutputStream);
        pICTImageWriter.write(bufferedImage);
        imageOutputStream.close();
    }
}

