/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.image.BufferedImageIcon;
import com.twelvemonkeys.image.ImageUtil;
import com.twelvemonkeys.imageio.plugins.pict.BitMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import com.twelvemonkeys.imageio.plugins.pict.QuickDrawContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class QDTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        BufferedImage bufferedImage = new BufferedImage(200, 200, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        QuickDrawContext quickDrawContext = new QuickDrawContext(graphics2D);
        try {
            quickDrawContext.fillRect(new Rectangle(200, 200), QuickDraw.WHITE);
            quickDrawContext.moveTo(10.0, 10.0);
            quickDrawContext.lineTo(10.0, 190.0);
            quickDrawContext.lineTo(190.0, 190.0);
            quickDrawContext.lineTo(190.0, 10.0);
            quickDrawContext.lineTo(10.0, 10.0);
            quickDrawContext.moveTo(10.0, 10.0);
            quickDrawContext.lineTo(190.0, 190.0);
            quickDrawContext.setPenSize(new Dimension(2, 2));
            quickDrawContext.frameRect(new Rectangle(15, 15, 20, 20));
            quickDrawContext.paintRect(new Rectangle(15, 45, 20, 20));
            quickDrawContext.fillRect(new Rectangle(15, 75, 20, 20), QuickDraw.DARK_GRAY);
            quickDrawContext.fillRect(new Rectangle(12, 102, 26, 26), new BitMapPattern(Color.GRAY));
            quickDrawContext.eraseRect(new Rectangle(15, 105, 20, 20));
            quickDrawContext.fillRect(new Rectangle(12, 132, 26, 8), QuickDraw.LIGT_GRAY);
            quickDrawContext.fillRect(new Rectangle(12, 140, 26, 10), new BitMapPattern(Color.RED));
            quickDrawContext.fillRect(new Rectangle(12, 150, 26, 8), QuickDraw.DARK_GRAY);
            quickDrawContext.invertRect(new Rectangle(15, 135, 20, 20));
            quickDrawContext.setPenSize(new Dimension(10, 10));
            quickDrawContext.moveTo(80.0, 30.0);
            quickDrawContext.line(80.0, 20.0);
            quickDrawContext.move(20.0, 0.0);
            quickDrawContext.line(0.0, -25.0);
            quickDrawContext.setPenPattern(QuickDraw.GRAY);
            quickDrawContext.moveTo(80.0, 70.0);
            quickDrawContext.line(80.0, 20.0);
            quickDrawContext.move(20.0, 0.0);
            quickDrawContext.line(0.0, -25.0);
            quickDrawContext.setPenPattern(new BitMapPattern(Color.GRAY));
            quickDrawContext.moveTo(80.0, 110.0);
            quickDrawContext.line(80.0, 20.0);
            quickDrawContext.move(20.0, 0.0);
            quickDrawContext.line(0.0, -25.0);
            quickDrawContext.setPenPattern(new BitMapPattern(Color.RED));
            quickDrawContext.moveTo(80.0, 150.0);
            quickDrawContext.line(80.0, 20.0);
            quickDrawContext.move(20.0, 0.0);
            quickDrawContext.line(0.0, -25.0);
            quickDrawContext.setPenPattern(new BitMapPattern(Color.ORANGE));
            quickDrawContext.setPenSize(new Dimension(2, 2));
            quickDrawContext.frameRoundRect(new Rectangle(45, 15, 20, 20), 4, 4);
            quickDrawContext.setPenPattern(new BitMapPattern(Color.DARK_GRAY));
            quickDrawContext.paintOval(new Rectangle(45, 45, 20, 20));
            quickDrawContext.invertArc(new Rectangle(46, 45, 20, 20), 45, 90);
            quickDrawContext.frameArc(new Rectangle(44, 75, 20, 20), 45, -270);
            quickDrawContext.fillArc(new Rectangle(46, 75, 20, 20), 45, 90, new BitMapPattern(Color.RED));
            quickDrawContext.invertPoly(new Polygon(new int[]{43, 55, 67}, new int[]{125, 103, 125}, 3));
            quickDrawContext.setPenPattern(new BitMapPattern(Color.ORANGE));
            Polygon polygon = new Polygon(new int[]{43, 52, 55, 58, 68, 59, 63, 55, 47, 51}, new int[]{143, 143, 133, 143, 143, 148, 157, 152, 157, 148}, 10);
            quickDrawContext.paintPoly(polygon);
            quickDrawContext.setPenNormal();
            quickDrawContext.framePoly(polygon);
            quickDrawContext.moveTo(15.0, 185.0);
            quickDrawContext.drawString("Java QuickDraw test");
        }
        finally {
            quickDrawContext.closePicture();
        }
        QDTest.showIt(bufferedImage, "QuickDraw Test");
    }

    public static void showIt(final BufferedImage bufferedImage, final String string) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrame jFrame = new JFrame(string);
                    jFrame.setDefaultCloseOperation(3);
                    jFrame.setLocationByPlatform(true);
                    JPanel jPanel = new JPanel(new BorderLayout());
                    GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                    BufferedImageIcon bufferedImageIcon = new BufferedImageIcon(ImageUtil.accelerate(bufferedImage, graphicsConfiguration));
                    JScrollPane jScrollPane = new JScrollPane(new JLabel(bufferedImageIcon));
                    jScrollPane.setBorder(null);
                    jPanel.add(jScrollPane);
                    jFrame.setContentPane(jPanel);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }
}

