/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import java.io.IOException;
import java.io.InputStream;

final class Plain1BitDecoder
extends InputStream {
    private final InputStream stream;
    private final int samplesPerRow;
    private int pos = 0;

    public Plain1BitDecoder(InputStream inputStream, int n) {
        this.stream = inputStream;
        this.samplesPerRow = n;
    }

    @Override
    public int read() throws IOException {
        int n = 0;
        for (int j = 7; j >= 0; --j) {
            int n2;
            while ((n2 = this.stream.read()) != -1 && Character.isWhitespace(n2)) {
            }
            if (n2 == -1) {
                if (j != 7) break;
                return -1;
            }
            int n3 = n2 - 48;
            n |= n3 << j;
            if (++this.pos < this.samplesPerRow) continue;
            this.pos = 0;
            break;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

