/*
 * Decompiled with CFR 0.152.
 */
package observable.mixin;

import java.util.function.Consumer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={World.class})
public class LevelMixin {
    @Overwrite
    public void func_217390_a(Consumer<Entity> consumer, Entity entity) {
        try {
            if (Props.notProcessing) {
                consumer.accept(entity);
            } else {
                if (Props.entityDepth < 0) {
                    Props.entityDepth = Thread.currentThread().getStackTrace().length - 1;
                }
                if (this instanceof ServerWorld) {
                    Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().process(entity);
                    Props.currentTarget.set(data2);
                    long start = System.nanoTime();
                    consumer.accept(entity);
                    data2.setTime(System.nanoTime() - start + data2.getTime());
                    Props.currentTarget.set(null);
                    data2.setTicks(data2.getTicks() + 1);
                } else {
                    consumer.accept(entity);
                }
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking entity");
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Entity being ticked");
            entity.func_85029_a(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    @Redirect(method={"tickBlockEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TickableBlockEntity;tick()V"))
    public final void redirectTick(ITickableTileEntity blockEntity) {
        if (Props.notProcessing) {
            blockEntity.func_73660_a();
        } else {
            if (Props.blockEntityDepth < 0) {
                Props.blockEntityDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            if (this instanceof ServerWorld) {
                Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processBlockEntity((TileEntity)blockEntity);
                Props.currentTarget.set(data2);
                long start = System.nanoTime();
                blockEntity.func_73660_a();
                data2.setTime(System.nanoTime() - start + data2.getTime());
                Props.currentTarget.set(null);
                data2.setTicks(data2.getTicks() + 1);
            } else {
                blockEntity.func_73660_a();
            }
        }
    }
}

