/*
 * Decompiled with CFR 0.152.
 */
package observable.shadow.imgui.api;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import observable.shadow.imgui.ImGui;
import observable.shadow.imgui.api.ContextKt;
import observable.shadow.imgui.classes.Context;
import observable.shadow.imgui.internal.sections.SettingsHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0016\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lobservable/shadow/imgui/api/settingsIniUtilities;", "", "loadIniSettingsFromDisk", "", "iniFilename", "", "loadIniSettingsFromMemory", "lines", "", "saveIniSettingsToDisk", "saveIniSettingsToMemory", "core"})
public interface settingsIniUtilities {
    public void loadIniSettingsFromDisk(@Nullable String var1);

    public void loadIniSettingsFromMemory(@NotNull List<String> var1);

    public void saveIniSettingsToDisk(@Nullable String var1);

    @NotNull
    public String saveIniSettingsToMemory();

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void loadIniSettingsFromDisk(@NotNull settingsIniUtilities $this, @Nullable String iniFilename) {
            if (iniFilename == null) {
                return;
            }
            File file = new File(Paths.get(iniFilename, new String[0]).toUri());
            if (file.exists() && file.canRead()) {
                $this.loadIniSettingsFromMemory(FilesKt.readLines$default((File)file, null, (int)1, null));
            }
        }

        /*
         * WARNING - void declaration
         */
        public static void loadIniSettingsFromMemory(@NotNull settingsIniUtilities $this, @NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            boolean bl = ContextKt.getG().getInitialized();
            boolean bl2 = false;
            int n = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            for (SettingsHandler handler : ContextKt.getG().getSettingsHandlers()) {
                Function2<Context, SettingsHandler, Unit> function2 = handler.getReadInitFn();
                if (function2 == null) continue;
                Context context = ContextKt.getG();
                SettingsHandler settingsHandler = handler;
                Intrinsics.checkNotNullExpressionValue((Object)settingsHandler, (String)"handler");
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)context, (Object)settingsHandler);
            }
            Object entryHandler = null;
            Object entryData = null;
            n = 0;
            int n2 = ((Collection)lines).size();
            while (n < n2) {
                void i2;
                CharSequence charSequence = lines.get((int)i2);
                boolean bl4 = false;
                String string = charSequence;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String line = ((Object)StringsKt.trim((CharSequence)string)).toString();
                charSequence = line;
                bl4 = false;
                if (charSequence.length() > 0) {
                    charSequence = line;
                    bl4 = false;
                    if (!StringsKt.isBlank((CharSequence)charSequence)) {
                        if (line.charAt(0) == '[' && StringsKt.last((CharSequence)line) == ']') {
                            int firstCloseBracket = StringsKt.indexOf$default((CharSequence)line, (char)']', (int)0, (boolean)false, (int)6, null);
                            if (firstCloseBracket != -1 && line.charAt(firstCloseBracket + 1) == '[') {
                                String name;
                                String type;
                                String string2 = line;
                                int n3 = 1;
                                int n4 = 0;
                                String string3 = string2;
                                if (string3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n3, firstCloseBracket), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                String string4 = line;
                                n4 = firstCloseBracket + 2;
                                int n5 = StringsKt.getLastIndex((CharSequence)line);
                                boolean bl5 = false;
                                String string5 = string4;
                                if (string5 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n4, n5), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                entryHandler = ImGui.INSTANCE.findSettingsHandler(type);
                                Function3<Context, SettingsHandler, String, Object> function3 = entryHandler;
                                entryData = function3 != null && (function3 = function3.getReadOpenFn()) != null ? function3.invoke((Object)ContextKt.getG(), entryHandler, (Object)name) : null;
                            }
                        } else if (entryHandler != null && entryData != null) {
                            Function4<Context, SettingsHandler, Object, String, Unit> function4 = entryHandler.getReadLineFn();
                            Intrinsics.checkNotNull(function4);
                            function4.invoke((Object)ContextKt.getG(), entryHandler, entryData, (Object)line);
                        }
                    }
                }
                ++i2;
            }
            ContextKt.getG().setSettingsLoaded(true);
            for (SettingsHandler handler : ContextKt.getG().getSettingsHandlers()) {
                Function2<Context, SettingsHandler, Unit> function2 = handler.getApplyAllFn();
                if (function2 == null) continue;
                Context context = ContextKt.getG();
                SettingsHandler settingsHandler = handler;
                Intrinsics.checkNotNullExpressionValue((Object)settingsHandler, (String)"handler");
                Unit cfr_ignored_1 = (Unit)function2.invoke((Object)context, (Object)settingsHandler);
            }
        }

        public static void saveIniSettingsToDisk(@NotNull settingsIniUtilities $this, @Nullable String iniFilename) {
            ContextKt.getG().setSettingsDirtyTimer(0.0f);
            if (iniFilename == null) {
                return;
            }
            File file = new File(Paths.get(iniFilename, new String[0]).toUri());
            if (file.exists() && file.canWrite()) {
                FilesKt.writeText$default((File)file, (String)$this.saveIniSettingsToMemory(), null, (int)2, null);
            }
        }

        @NotNull
        public static String saveIniSettingsToMemory(@NotNull settingsIniUtilities $this) {
            ContextKt.getG().setSettingsDirtyTimer(0.0f);
            StringBuilder buf = new StringBuilder();
            for (SettingsHandler handler : ContextKt.getG().getSettingsHandlers()) {
                Function3<Context, SettingsHandler, StringBuilder, Unit> function3 = handler.getWriteAllFn();
                Intrinsics.checkNotNull(function3);
                Context context = ContextKt.getG();
                SettingsHandler settingsHandler = handler;
                Intrinsics.checkNotNullExpressionValue((Object)settingsHandler, (String)"handler");
                function3.invoke((Object)context, (Object)settingsHandler, (Object)buf);
            }
            Context context = ContextKt.getG();
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
            context.setSettingsIniData(string);
            return ContextKt.getG().getSettingsIniData();
        }
    }
}

