/*
 * Decompiled with CFR 0.152.
 */
package observable.shadow.imgui.internal.api;

import glm_.ExtensionsKt;
import glm_.vec2.Vec2;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import observable.shadow.imgui.Dir;
import observable.shadow.imgui.Flags___enumerationsKt;
import observable.shadow.imgui.ImGui;
import observable.shadow.imgui.NavInput;
import observable.shadow.imgui.WindowFlag;
import observable.shadow.imgui.api.ContextKt;
import observable.shadow.imgui.internal.api.navigation$WhenMappings;
import observable.shadow.imgui.internal.classes.Rect;
import observable.shadow.imgui.internal.classes.Window;
import observable.shadow.imgui.internal.sections.InputReadMode;
import observable.shadow.imgui.internal.sections.NavDirSourceFlag;
import observable.shadow.imgui.internal.sections.NavForward;
import observable.shadow.imgui.internal.sections.NavLayer;
import observable.shadow.imgui.internal.sections.Widgets_support_flags__enums__data_structuresKt;
import observable.shadow.imgui.static.NavigationKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0016J(\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0005j\u0002`\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J,\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060\u0005j\u0002`&H\u0016J\u001c\u0010'\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010%\u001a\u00060\u0005j\u0002`&H\u0016J0\u0010(\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010)\u001a\u00020*2\n\u0010+\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010,\u001a\u00020$H\u0016J(\u0010-\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010)\u001a\u00020*2\n\u0010+\u001a\u00060\u0005j\u0002`\u0006H\u0016\u00a8\u0006."}, d2={"Lobservable/shadow/imgui/internal/api/navigation;", "", "activateItem", "", "id", "", "Lobservable/shadow/imgui/ID;", "calcTypematicRepeatAmount", "t0", "", "t1", "repeatDelay", "repeatRate", "getNavInputAmount", "n", "Lobservable/shadow/imgui/NavInput;", "mode", "Lobservable/shadow/imgui/internal/sections/InputReadMode;", "getNavInputAmount2d", "Lglm_/vec2/Vec2;", "dirSources", "Lobservable/shadow/imgui/internal/sections/NavDirSourceFlags;", "slowFactor", "fastFactor", "navInitWindow", "window", "Lobservable/shadow/imgui/internal/classes/Window;", "forceReinit", "", "navMoveRequestButNoResultYet", "navMoveRequestCancel", "navMoveRequestForward", "moveDir", "Lobservable/shadow/imgui/Dir;", "clipDir", "bbRel", "Lobservable/shadow/imgui/internal/classes/Rect;", "moveFlags", "Lobservable/shadow/imgui/internal/sections/NavMoveFlags;", "navMoveRequestTryWrapping", "setNavIDWithRectRel", "navLayer", "Lobservable/shadow/imgui/internal/sections/NavLayer;", "focusScopeId", "rectRel", "setNavId", "core"})
public interface navigation {
    public void navInitWindow(@NotNull Window var1, boolean var2);

    public boolean navMoveRequestButNoResultYet();

    public void navMoveRequestCancel();

    public void navMoveRequestForward(@NotNull Dir var1, @NotNull Dir var2, @NotNull Rect var3, int var4);

    public void navMoveRequestTryWrapping(@NotNull Window var1, int var2);

    public float getNavInputAmount(@NotNull NavInput var1, @NotNull InputReadMode var2);

    @NotNull
    public Vec2 getNavInputAmount2d(int var1, @NotNull InputReadMode var2, float var3, float var4);

    public int calcTypematicRepeatAmount(float var1, float var2, float var3, float var4);

    public void activateItem(int var1);

    public void setNavId(int var1, @NotNull NavLayer var2, int var3);

    public void setNavIDWithRectRel(int var1, @NotNull NavLayer var2, int var3, @NotNull Rect var4);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void navInitWindow(@NotNull navigation $this, @NotNull Window window, boolean forceReinit) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            boolean bl = Intrinsics.areEqual((Object)window, (Object)ContextKt.getG().getNavWindow());
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            boolean initForNav = false;
            if (Flags___enumerationsKt.hasnt(window.getFlags(), WindowFlag.NoNavInputs) && (Flags___enumerationsKt.hasnt(window.getFlags(), WindowFlag._ChildWindow) || Flags___enumerationsKt.has(window.getFlags(), WindowFlag._Popup) || window.getNavLastIds()[0] == 0 || forceReinit)) {
                initForNav = true;
            }
            if (initForNav) {
                $this.setNavId(0, ContextKt.getG().getNavLayer(), 0);
                ContextKt.getG().setNavInitRequest(true);
                ContextKt.getG().setNavInitRequestFromMove(false);
                ContextKt.getG().setNavInitResultId(0);
                ContextKt.getG().setNavInitResultRectRel(new Rect());
                NavigationKt.navUpdateAnyRequestFlag();
            } else {
                ContextKt.getG().setNavId(window.getNavLastIds()[0]);
                ContextKt.getG().setNavFocusScopeId(0);
            }
        }

        public static boolean navMoveRequestButNoResultYet(@NotNull navigation $this) {
            return ContextKt.getG().getNavMoveRequest() && ContextKt.getG().getNavMoveResultLocal().getId() == 0 && ContextKt.getG().getNavMoveResultOther().getId() == 0;
        }

        public static void navMoveRequestCancel(@NotNull navigation $this) {
            ContextKt.getG().setNavMoveRequest(false);
            NavigationKt.navUpdateAnyRequestFlag();
        }

        public static void navMoveRequestForward(@NotNull navigation $this, @NotNull Dir moveDir, @NotNull Dir clipDir, @NotNull Rect bbRel, int moveFlags) {
            Intrinsics.checkNotNullParameter((Object)((Object)moveDir), (String)"moveDir");
            Intrinsics.checkNotNullParameter((Object)((Object)clipDir), (String)"clipDir");
            Intrinsics.checkNotNullParameter((Object)bbRel, (String)"bbRel");
            boolean bl = ContextKt.getG().getNavMoveRequestForward() == NavForward.None;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $this.navMoveRequestCancel();
            ContextKt.getG().setNavMoveDir(moveDir);
            ContextKt.getG().setNavMoveDir(clipDir);
            ContextKt.getG().setNavMoveRequestForward(NavForward.ForwardQueued);
            ContextKt.getG().setNavMoveRequestFlags(moveFlags);
            Window window = ContextKt.getG().getNavWindow();
            Intrinsics.checkNotNull((Object)window);
            Widgets_support_flags__enums__data_structuresKt.set(window.getNavRectRel(), ContextKt.getG().getNavLayer(), bbRel);
        }

        public static void navMoveRequestTryWrapping(@NotNull navigation $this, @NotNull Window window, int moveFlags) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            ContextKt.getG().setNavWrapRequestWindow(window);
            ContextKt.getG().setNavWrapRequestFlags(moveFlags);
        }

        public static float getNavInputAmount(@NotNull navigation $this, @NotNull NavInput n, @NotNull InputReadMode mode) {
            float f2;
            Intrinsics.checkNotNullParameter((Object)((Object)n), (String)"n");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            int i2 = n.i;
            if (mode == InputReadMode.Down) {
                return ImGui.INSTANCE.getIo().getNavInputs()[i2];
            }
            float t = ImGui.INSTANCE.getIo().getNavInputsDownDuration()[i2];
            if (t < 0.0f && mode == InputReadMode.Released) {
                f2 = ImGui.INSTANCE.getIo().getNavInputsDownDurationPrev()[i2] >= 0.0f ? 1.0f : 0.0f;
            } else if (t < 0.0f) {
                f2 = 0.0f;
            } else {
                int n2;
                switch (navigation$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                    case 1: {
                        if (t == 0.0f) {
                            n2 = 1;
                            break;
                        }
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = $this.calcTypematicRepeatAmount(t - ImGui.INSTANCE.getIo().getDeltaTime(), t, ImGui.INSTANCE.getIo().getKeyRepeatDelay() * 0.72f, ImGui.INSTANCE.getIo().getKeyRepeatRate() * 0.8f);
                        break;
                    }
                    case 3: {
                        n2 = $this.calcTypematicRepeatAmount(t - ImGui.INSTANCE.getIo().getDeltaTime(), t, ImGui.INSTANCE.getIo().getKeyRepeatDelay() * 1.25f, ImGui.INSTANCE.getIo().getKeyRepeatRate() * 2.0f);
                        break;
                    }
                    case 4: {
                        n2 = $this.calcTypematicRepeatAmount(t - ImGui.INSTANCE.getIo().getDeltaTime(), t, ImGui.INSTANCE.getIo().getKeyRepeatDelay() * 0.72f, ImGui.INSTANCE.getIo().getKeyRepeatRate() * 0.3f);
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                f2 = ExtensionsKt.getF(n2);
            }
            return f2;
        }

        @NotNull
        public static Vec2 getNavInputAmount2d(@NotNull navigation $this, int dirSources, @NotNull InputReadMode mode, float slowFactor, float fastFactor) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Vec2 delta = new Vec2();
            if (Widgets_support_flags__enums__data_structuresKt.has(dirSources, NavDirSourceFlag.Keyboard)) {
                delta.plusAssign(new Vec2($this.getNavInputAmount(NavInput._KeyRight, mode) - $this.getNavInputAmount(NavInput._KeyLeft, mode), $this.getNavInputAmount(NavInput._KeyDown, mode) - $this.getNavInputAmount(NavInput._KeyUp, mode)));
            }
            if (Widgets_support_flags__enums__data_structuresKt.has(dirSources, NavDirSourceFlag.PadDPad)) {
                delta.plusAssign(new Vec2($this.getNavInputAmount(NavInput.DpadRight, mode) - $this.getNavInputAmount(NavInput.DpadLeft, mode), $this.getNavInputAmount(NavInput.DpadDown, mode) - $this.getNavInputAmount(NavInput.DpadUp, mode)));
            }
            if (Widgets_support_flags__enums__data_structuresKt.has(dirSources, NavDirSourceFlag.PadLStick)) {
                delta.plusAssign(new Vec2($this.getNavInputAmount(NavInput.LStickRight, mode) - $this.getNavInputAmount(NavInput.LStickLeft, mode), $this.getNavInputAmount(NavInput.LStickDown, mode) - $this.getNavInputAmount(NavInput.LStickUp, mode)));
            }
            if (slowFactor != 0.0f && NavInput.TweakSlow.isDown()) {
                delta.timesAssign(slowFactor);
            }
            if (fastFactor != 0.0f && NavInput.TweakFast.isDown()) {
                delta.timesAssign(fastFactor);
            }
            return delta;
        }

        public static /* synthetic */ Vec2 getNavInputAmount2d$default(navigation navigation2, int n, InputReadMode inputReadMode, float f2, float f3, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNavInputAmount2d");
            }
            if ((n2 & 4) != 0) {
                f2 = 0.0f;
            }
            if ((n2 & 8) != 0) {
                f3 = 0.0f;
            }
            return navigation2.getNavInputAmount2d(n, inputReadMode, f2, f3);
        }

        public static int calcTypematicRepeatAmount(@NotNull navigation $this, float t0, float t1, float repeatDelay, float repeatRate) {
            int n;
            if (t1 == 0.0f) {
                n = 1;
            } else if (t0 >= t1) {
                n = 0;
            } else if (repeatRate <= 0.0f) {
                n = ExtensionsKt.getI(t0 < repeatDelay && t1 >= repeatDelay);
            } else {
                int countT0 = t0 < repeatDelay ? -1 : ExtensionsKt.getI(Float.valueOf((t0 - repeatDelay) / repeatRate));
                int countT1 = t1 < repeatDelay ? -1 : ExtensionsKt.getI(Float.valueOf((t1 - repeatDelay) / repeatRate));
                n = countT1 - countT0;
            }
            return n;
        }

        public static void activateItem(@NotNull navigation $this, int id) {
            ContextKt.getG().setNavNextActivateId(id);
        }

        public static void setNavId(@NotNull navigation $this, int id, @NotNull NavLayer navLayer, int focusScopeId) {
            Intrinsics.checkNotNullParameter((Object)((Object)navLayer), (String)"navLayer");
            ContextKt.getG().setNavId(id);
            ContextKt.getG().setNavFocusScopeId(focusScopeId);
            Window window = ContextKt.getG().getNavWindow();
            Intrinsics.checkNotNull((Object)window);
            Widgets_support_flags__enums__data_structuresKt.set(window.getNavLastIds(), navLayer, id);
        }

        public static void setNavIDWithRectRel(@NotNull navigation $this, int id, @NotNull NavLayer navLayer, int focusScopeId, @NotNull Rect rectRel) {
            Intrinsics.checkNotNullParameter((Object)((Object)navLayer), (String)"navLayer");
            Intrinsics.checkNotNullParameter((Object)rectRel, (String)"rectRel");
            $this.setNavId(id, navLayer, focusScopeId);
            Window window = ContextKt.getG().getNavWindow();
            Intrinsics.checkNotNull((Object)window);
            Widgets_support_flags__enums__data_structuresKt.get(window.getNavRectRel(), navLayer).put(rectRel);
            ContextKt.getG().setNavMousePosDirty(true);
            ContextKt.getG().setNavDisableHighlight(false);
            ContextKt.getG().setNavDisableMouseHover(true);
        }
    }
}

