/*
 * Decompiled with CFR 0.152.
 */
package observable.shadow.imgui.internal.classes;

import glm_.glm;
import glm_.vec2.Vec2;
import glm_.vec2.Vec2i;
import glm_.vec4.Vec4;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import observable.shadow.imgui.internal.Generic_helpersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u000fB'\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015J\u0011\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0007H\u0086\u0004J\u0011\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004J\u0011\u00103\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004J\u0011\u00104\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004J\u0011\u00105\u001a\u00020!2\u0006\u00102\u001a\u00020\u0007H\u0086\u0006J\u0011\u00105\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0006J\u0011\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u0007H\u0086\u0004J\u0011\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u0011H\u0086\u0004J\u0006\u00108\u001a\u000201J\u0011\u00109\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0004J\u0011\u00109\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0004J\u0016\u0010:\u001a\u0002012\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007J\u0011\u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020\fH\u0086\u0004J\u0011\u0010:\u001a\u0002012\u0006\u0010<\u001a\u00020\u0000H\u0086\u0004J&\u0010:\u001a\u0002012\u0006\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u00020\u0011J\b\u0010A\u001a\u00020BH\u0016J\u0006\u0010C\u001a\u00020\fJ\u0011\u0010D\u001a\u0002012\u0006\u0010E\u001a\u00020\u0007H\u0086\u0004J\u0011\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020\u0011H\u0086\u0004J\u0011\u0010H\u001a\u0002012\u0006\u0010I\u001a\u00020\u0011H\u0086\u0004R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u001a\u0010\u0005\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010%R\u001a\u0010\u0003\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0018\"\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0018R\u0011\u0010*\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018R\u0011\u0010,\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0018R\u0011\u0010.\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001f\u00a8\u0006J"}, d2={"Lobservable/shadow/imgui/internal/classes/Rect;", "", "()V", "min", "Lglm_/vec2/Vec2i;", "max", "(Lglm_/vec2/Vec2i;Lglm_/vec2/Vec2i;)V", "Lglm_/vec2/Vec2;", "(Lglm_/vec2/Vec2i;Lglm_/vec2/Vec2;)V", "(Lglm_/vec2/Vec2;Lglm_/vec2/Vec2;)V", "(Lglm_/vec2/Vec2;Lglm_/vec2/Vec2i;)V", "v", "Lglm_/vec4/Vec4;", "(Lglm_/vec4/Vec4;)V", "r", "(Limgui/internal/classes/Rect;)V", "x1", "", "y1", "x2", "y2", "(FFFF)V", "bl", "getBl", "()Lglm_/vec2/Vec2;", "br", "getBr", "center", "getCenter", "height", "getHeight", "()F", "isInverted", "", "()Z", "getMax", "setMax", "(Lglm_/vec2/Vec2;)V", "getMin", "setMin", "size", "getSize", "tl", "getTl", "tr", "getTr", "width", "getWidth", "add", "", "p", "clipWith", "clipWithFull", "contains", "expand", "amount", "floor", "overlaps", "put", "vec4", "rect", "minX", "minY", "maxX", "maxY", "toString", "", "toVec4", "translate", "d", "translateX", "dx", "translateY", "dy", "core"})
public final class Rect {
    @NotNull
    private Vec2 min;
    @NotNull
    private Vec2 max;

    @NotNull
    public final Vec2 getMin() {
        return this.min;
    }

    public final void setMin(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.min = vec2;
    }

    @NotNull
    public final Vec2 getMax() {
        return this.max;
    }

    public final void setMax(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.max = vec2;
    }

    @NotNull
    public final Vec2 getCenter() {
        return this.min.plus(this.max).times(0.5f);
    }

    @NotNull
    public final Vec2 getSize() {
        return this.max.minus(this.min);
    }

    public final float getWidth() {
        return this.max.getX().floatValue() - this.min.getX().floatValue();
    }

    public final float getHeight() {
        return this.max.getY().floatValue() - this.min.getY().floatValue();
    }

    @NotNull
    public final Vec2 getTl() {
        return new Vec2(this.min);
    }

    @NotNull
    public final Vec2 getTr() {
        return new Vec2(this.max.getX().floatValue(), this.min.getY().floatValue());
    }

    @NotNull
    public final Vec2 getBl() {
        return new Vec2(this.min.getX().floatValue(), this.max.getY().floatValue());
    }

    @NotNull
    public final Vec2 getBr() {
        return new Vec2(this.max);
    }

    public final boolean contains(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.getX().floatValue() >= this.min.getX().floatValue() && p.getY().floatValue() >= this.min.getY().floatValue() && p.getX().floatValue() < this.max.getX().floatValue() && p.getY().floatValue() < this.max.getY().floatValue();
    }

    public final boolean contains(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.min.getX().floatValue() >= this.min.getX().floatValue() && r.min.getY().floatValue() >= this.min.getY().floatValue() && r.max.getX().floatValue() <= this.max.getX().floatValue() && r.max.getY().floatValue() <= this.max.getY().floatValue();
    }

    public final boolean overlaps(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.min.getY().floatValue() < this.max.getY().floatValue() && r.max.getY().floatValue() > this.min.getY().floatValue() && r.min.getX().floatValue() < this.max.getX().floatValue() && r.max.getX().floatValue() > this.min.getX().floatValue();
    }

    public final boolean overlaps(@NotNull Vec4 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        return v2.getY().floatValue() < this.max.getY().floatValue() && v2.getW().floatValue() > this.min.getY().floatValue() && v2.getX().floatValue() < this.max.getX().floatValue() && v2.getZ().floatValue() > this.min.getX().floatValue();
    }

    public final void add(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.min.getX().floatValue() > p.getX().floatValue()) {
            this.min.setX(p.getX().floatValue());
        }
        if (this.min.getY().floatValue() > p.getY().floatValue()) {
            this.min.setY(p.getY().floatValue());
        }
        if (this.max.getX().floatValue() < p.getX().floatValue()) {
            this.max.setX(p.getX().floatValue());
        }
        if (this.max.getY().floatValue() < p.getY().floatValue()) {
            this.max.setY(p.getY().floatValue());
        }
    }

    public final void add(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (this.min.getX().floatValue() > r.min.getX().floatValue()) {
            this.min.setX(r.min.getX().floatValue());
        }
        if (this.min.getY().floatValue() > r.min.getY().floatValue()) {
            this.min.setY(r.min.getY().floatValue());
        }
        if (this.max.getX().floatValue() < r.max.getX().floatValue()) {
            this.max.setX(r.max.getX().floatValue());
        }
        if (this.max.getY().floatValue() < r.max.getY().floatValue()) {
            this.max.setY(r.max.getY().floatValue());
        }
    }

    public final void expand(float amount) {
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() - amount);
        Vec2 vec22 = this.min;
        vec22.setY(vec22.getY().floatValue() - amount);
        Vec2 vec23 = this.max;
        vec23.setX(vec23.getX().floatValue() + amount);
        Vec2 vec24 = this.max;
        vec24.setY(vec24.getY().floatValue() + amount);
    }

    public final void expand(@NotNull Vec2 amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() - amount.getX().floatValue());
        Vec2 vec22 = this.min;
        vec22.setY(vec22.getY().floatValue() - amount.getY().floatValue());
        Vec2 vec23 = this.max;
        vec23.setX(vec23.getX().floatValue() + amount.getX().floatValue());
        Vec2 vec24 = this.max;
        vec24.setY(vec24.getY().floatValue() + amount.getY().floatValue());
    }

    public final void translate(@NotNull Vec2 d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() + d.getX().floatValue());
        Vec2 vec22 = this.min;
        vec22.setY(vec22.getY().floatValue() + d.getY().floatValue());
        Vec2 vec23 = this.max;
        vec23.setX(vec23.getX().floatValue() - d.getX().floatValue());
        Vec2 vec24 = this.max;
        vec24.setY(vec24.getY().floatValue() - d.getY().floatValue());
    }

    public final void translateX(float dx2) {
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() + dx2);
        Vec2 vec22 = this.max;
        vec22.setX(vec22.getX().floatValue() + dx2);
    }

    public final void translateY(float dy) {
        Vec2 vec2 = this.min;
        vec2.setY(vec2.getY().floatValue() + dy);
        Vec2 vec22 = this.max;
        vec22.setY(vec22.getY().floatValue() + dy);
    }

    public final void clipWith(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.min = this.min.max(r.min);
        this.max = this.max.min(r.max);
    }

    public final void clipWithFull(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.min = glm.INSTANCE.clamp(this.min, r.min, r.max);
        this.max = glm.INSTANCE.clamp(this.max, r.min, r.max);
    }

    public final void floor() {
        this.min.setX(Generic_helpersKt.floor(this.min.getX().floatValue()));
        this.min.setY(Generic_helpersKt.floor(this.min.getY().floatValue()));
        this.max.setX(Generic_helpersKt.floor(this.max.getX().floatValue()));
        this.max.setY(Generic_helpersKt.floor(this.max.getY().floatValue()));
    }

    public final boolean isInverted() {
        return this.min.getX().floatValue() > this.max.getX().floatValue() || this.min.getY().floatValue() > this.max.getY().floatValue();
    }

    @NotNull
    public final Vec4 toVec4() {
        return new Vec4(this.min, this.max);
    }

    public final void put(@NotNull Vec2 min, @NotNull Vec2 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min.put(min);
        this.max.put(max);
    }

    public final void put(float minX, float minY, float maxX, float maxY) {
        this.min.put(minX, minY);
        this.max.put(maxX, maxY);
    }

    public final void put(@NotNull Vec4 vec42) {
        Intrinsics.checkNotNullParameter((Object)vec42, (String)"vec4");
        this.min.put(vec42.getX().floatValue(), vec42.getY().floatValue());
        this.max.put(vec42.getZ().floatValue(), vec42.getW().floatValue());
    }

    public final void put(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.min.put(rect.min);
        this.max.put(rect.max);
    }

    @NotNull
    public String toString() {
        return "min: " + this.min + ", max: " + this.max;
    }

    public Rect() {
        this.min = new Vec2();
        this.max = new Vec2();
    }

    public Rect(@NotNull Vec2i min, @NotNull Vec2i max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(min);
        this.max.put(max);
    }

    public Rect(@NotNull Vec2i min, @NotNull Vec2 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(min);
        this.max = max;
    }

    public Rect(@NotNull Vec2 min, @NotNull Vec2 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min = new Vec2(min);
        this.max = new Vec2(max);
    }

    public Rect(@NotNull Vec2 min, @NotNull Vec2i max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min = new Vec2(min);
        this.max = new Vec2(max);
    }

    public Rect(@NotNull Vec4 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(v2.getX().floatValue(), v2.getY().floatValue());
        this.max.put(v2.getZ().floatValue(), v2.getW().floatValue());
    }

    public Rect(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(r.min);
        this.max.put(r.max);
    }

    public Rect(float x1, float y1, float x2, float y2) {
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(x1, y1);
        this.max.put(x2, y2);
    }
}

