/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IRecipeDefinition
extends Comparable<IRecipeDefinition> {
    public Set<IngredientComponent<?, ?>> getInputComponents();

    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> var1);

    public IMixedIngredients getOutput();

    public static CompoundNBT serialize(IRecipeDefinition recipe) {
        CompoundNBT tag = new CompoundNBT();
        CompoundNBT inputTag = new CompoundNBT();
        for (IngredientComponent<?, ?> component : recipe.getInputComponents()) {
            ListNBT instances = new ListNBT();
            for (IPrototypedIngredientAlternatives<?, ?> ingredient : recipe.getInputs(component)) {
                CompoundNBT subTag = new CompoundNBT();
                IPrototypedIngredientAlternatives.ISerializer<?> serializer = ingredient.getSerializer();
                subTag.func_218657_a("val", serializer.serialize(component, ingredient));
                subTag.func_74774_a("type", serializer.getId());
                instances.add((Object)subTag);
            }
            inputTag.func_218657_a(component.getRegistryName().toString(), (INBT)instances);
        }
        tag.func_218657_a("input", (INBT)inputTag);
        tag.func_218657_a("output", (INBT)IMixedIngredients.serialize(recipe.getOutput()));
        return tag;
    }

    public static RecipeDefinition deserialize(CompoundNBT tag) throws IllegalArgumentException {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        if (!tag.func_74764_b("input")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid input tag");
        }
        if (!tag.func_74764_b("output")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid output tag");
        }
        CompoundNBT inputTag = tag.func_74775_l("input");
        for (String componentName : inputTag.func_150296_c()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            INBT subTag = inputTag.func_74781_a(componentName);
            if (!(subTag instanceof ListNBT)) {
                throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instances");
            }
            ListNBT instancesTag = (ListNBT)subTag;
            ArrayList instances = Lists.newArrayList();
            for (INBT instanceTag : instancesTag) {
                IPrototypedIngredientAlternatives.ISerializer alternativeSerializer;
                if (instanceTag instanceof CompoundNBT) {
                    CompoundNBT instanceTagCompound = (CompoundNBT)instanceTag;
                    byte type = instanceTagCompound.func_74771_c("type");
                    alternativeSerializer = (IPrototypedIngredientAlternatives.ISerializer)IPrototypedIngredientAlternatives.SERIALIZERS.get(type);
                    if (alternativeSerializer == null) {
                        throw new IllegalArgumentException("Could not find a prototyped ingredient alternative serializer for id " + type);
                    }
                } else {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid reference to instances");
                }
                INBT deserializeTag = ((CompoundNBT)instanceTag).func_74781_a("val");
                Object alternatives = alternativeSerializer.deserialize(component, deserializeTag);
                instances.add(alternatives);
            }
            inputs.put(component, instances);
        }
        MixedIngredients output = IMixedIngredients.deserialize(tag.func_74775_l("output"));
        return new RecipeDefinition(inputs, output);
    }
}

