/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;

public class IngredientComponentStorageWrapperHandlerEnergyStorage
implements IIngredientComponentStorageWrapperHandler<Long, Boolean, IEnergyStorage> {
    private final IngredientComponent<Long, Boolean> ingredientComponent;

    public IngredientComponentStorageWrapperHandlerEnergyStorage(IngredientComponent<Long, Boolean> ingredientComponent) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
    }

    @Override
    public IIngredientComponentStorage<Long, Boolean> wrapComponentStorage(IEnergyStorage storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public IEnergyStorage wrapStorage(IIngredientComponentStorage<Long, Boolean> componentStorage) {
        return new EnergyStorageWrapper(componentStorage);
    }

    @Override
    @Nullable
    public LazyOptional<IEnergyStorage> getStorage(ICapabilityProvider capabilityProvider, @Nullable Direction facing) {
        return capabilityProvider.getCapability(CapabilityEnergy.ENERGY, facing);
    }

    @Override
    public IngredientComponent<Long, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    public static class EnergyStorageWrapper
    implements IEnergyStorage {
        private final IIngredientComponentStorage<Long, Boolean> storage;

        public EnergyStorageWrapper(IIngredientComponentStorage<Long, Boolean> storage) {
            this.storage = storage;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive - Helpers.castSafe((long)this.storage.insert(Long.valueOf(maxReceive), simulate));
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return Helpers.castSafe((long)this.storage.extract(maxExtract, simulate));
        }

        public int getEnergyStored() {
            long total = 0L;
            for (Long stored : this.storage) {
                total = Math.addExact(total, stored);
            }
            return Helpers.castSafe((long)total);
        }

        public int getMaxEnergyStored() {
            return Helpers.castSafe((long)this.storage.getMaxQuantity());
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<Long, Boolean> {
        private final IngredientComponent<Long, Boolean> ingredientComponent;
        private final IEnergyStorage storage;

        public ComponentStorageWrapper(IngredientComponent<Long, Boolean> ingredientComponent, IEnergyStorage storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<Long, Boolean> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<Long> iterator() {
            return Iterators.forArray((Object[])new Long[]{this.storage.getEnergyStored()});
        }

        @Override
        public Iterator<Long> iterator(@Nonnull Long prototype, Boolean matchFlags) {
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storage.getMaxEnergyStored();
        }

        @Override
        public Long insert(@Nonnull Long ingredient, boolean simulate) {
            return ingredient - (long)this.storage.receiveEnergy(Helpers.castSafe((long)ingredient), simulate);
        }

        @Override
        public Long extract(@Nonnull Long prototype, Boolean matchFlags, boolean simulate) {
            int extractable;
            if (matchFlags.booleanValue() && (long)(extractable = this.storage.extractEnergy(Helpers.castSafe((long)prototype), true)) != prototype) {
                return 0L;
            }
            return this.storage.extractEnergy(Helpers.castSafe((long)prototype), simulate);
        }

        @Override
        public Long extract(long maxQuantity, boolean simulate) {
            return this.storage.extractEnergy(Helpers.castSafe((long)maxQuantity), simulate);
        }
    }
}

