/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.module.BlossomTreesModule;

public class BlossomLeavesBlock
extends LeavesBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public BlossomLeavesBlock(String colorName, QuarkModule module, MaterialColor color) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151584_j, (MaterialColor)color).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.HOE).func_226896_b_().func_235827_a_((s, r, p, t) -> false).func_235842_b_((s, r, p) -> false).func_235847_c_((s, r, p) -> false));
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)(colorName + "_blossom_leaves"));
        RegistryHelper.setCreativeTab((Block)this, (ItemGroup)ItemGroup.field_78031_c);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT_MIPPED);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175623_d(pos.func_177977_b()) && rand.nextInt(5) == 0 && BlossomTreesModule.dropLeafParticles) {
            double windStrength = 5.0 + Math.cos((double)worldIn.func_82737_E() / 2000.0) * 2.0;
            double windX = Math.cos((double)worldIn.func_82737_E() / 1200.0) * windStrength;
            double windZ = Math.sin((double)worldIn.func_82737_E() / 1000.0) * windStrength;
            worldIn.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, stateIn), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, windX, -1.0, windZ);
        }
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public BlossomLeavesBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

