/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RealisticChunkGenerator
extends NoiseChunkGenerator {
    public static final Codec<RealisticChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(generator -> generator.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.seed), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(generator -> generator.field_236080_h_)).apply((Applicative)instance, instance.stable(RealisticChunkGenerator::new)));
    private final long seed;

    public RealisticChunkGenerator(BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> settings) {
        super(biomeProvider, seed, settings);
        this.seed = seed;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long seed) {
        return new RealisticChunkGenerator(this.field_222542_c.func_230320_a_(seed), seed, this.field_236080_h_);
    }

    public void func_222548_a(double[] noiseColumn, int noiseX, int noiseZ) {
        double variance;
        double densityMax;
        NoiseSettings settings = ((DimensionSettings)this.field_236080_h_.get()).func_236113_b_();
        if (this.field_236083_v_ != null) {
            densityMax = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.field_236083_v_, (int)noiseX, (int)noiseZ) - 8.0f;
            variance = densityMax > 0.0 ? 0.25 : 1.0;
        } else {
            float weightedScale = 0.0f;
            float weightedDepth = 0.0f;
            float weight = 0.0f;
            int seaLevel = this.func_230356_f_();
            float centerDepth = this.field_222542_c.func_225526_b_(noiseX, seaLevel, noiseZ).func_185355_j();
            for (int localX = -2; localX <= 2; ++localX) {
                for (int localZ = -2; localZ <= 2; ++localZ) {
                    Biome biome = this.field_222542_c.func_225526_b_(noiseX + localX, seaLevel, noiseZ + localZ);
                    float depth = biome.func_185355_j();
                    float scale = biome.func_185360_m();
                    float weightScale = depth > centerDepth ? 0.5f : 1.0f;
                    float weightAt = weightScale * field_236081_j_[localX + 2 + (localZ + 2) * 5] / (depth + 2.0f);
                    weightedScale += scale * weightAt;
                    weightedDepth += depth * weightAt;
                    weight += weightAt;
                }
            }
            float scaledDepth = weightedDepth / weight;
            float scaledScale = weightedScale / weight;
            double finalDepth = scaledDepth * 0.5f - 0.125f;
            double finalScale = scaledScale * 0.9f + 0.1f;
            densityMax = finalDepth * 0.265625;
            variance = 107.04 / finalScale;
        }
        double horizontalNoiseScale = 175.0;
        double verticalNoiseScale = 75.0;
        double horizontalNoiseStretch = horizontalNoiseScale / 165.0;
        double verticalNoiseStretch = verticalNoiseScale / 106.612;
        double topTarget = settings.func_236172_c_().func_236186_a_();
        double topSize = settings.func_236172_c_().func_236188_b_();
        double topOffset = settings.func_236172_c_().func_236189_c_();
        double bottomTarget = settings.func_236173_d_().func_236186_a_();
        double bottomSize = settings.func_236173_d_().func_236188_b_();
        double bottomOffset = settings.func_236173_d_().func_236189_c_();
        double randomDensityOffset = settings.func_236179_j_() ? this.func_236095_c_(noiseX, noiseZ) : 0.0;
        double densityFactor = settings.func_236176_g_();
        double densityOffset = settings.func_236177_h_();
        for (int y = 0; y <= this.field_222566_m; ++y) {
            double target;
            double noise = this.func_222552_a(noiseX, y, noiseZ, horizontalNoiseScale, verticalNoiseScale, horizontalNoiseStretch, verticalNoiseStretch);
            double yOffset = 1.0 - (double)y * 2.0 / (double)this.field_222566_m + randomDensityOffset;
            double finalDensity = yOffset * densityFactor + densityOffset;
            double falloff = (finalDensity + densityMax) * variance;
            noise = falloff > 0.0 ? (noise += falloff * 4.0) : (noise += falloff);
            if (topSize > 0.0) {
                target = ((double)(this.field_222566_m - y) - topOffset) / topSize;
                noise = MathHelper.func_151238_b((double)topTarget, (double)noise, (double)target);
            }
            if (bottomSize > 0.0) {
                target = ((double)y - bottomOffset) / bottomSize;
                noise = MathHelper.func_151238_b((double)bottomTarget, (double)noise, (double)target);
            }
            noiseColumn[y] = noise;
        }
    }
}

