/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.handlers.scripts.ConditionEvaluator;

@OnlyIn(value=Dist.CLIENT)
public abstract class BlockEffect {
    private int chance;
    protected String conditions = "";

    public BlockEffect() {
        this(100);
    }

    protected BlockEffect(int chance) {
        this.chance = chance;
    }

    @Nonnull
    public abstract BlockEffectType getEffectType();

    public void setConditions(@Nullable String conditions) {
        this.conditions = conditions == null ? "" : conditions.intern();
    }

    @Nonnull
    public String getConditions() {
        return this.conditions;
    }

    public void setChance(int chance) {
        this.chance = chance;
    }

    public int getChance() {
        return this.chance;
    }

    public boolean alwaysExecute() {
        return this.chance == 0;
    }

    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (!this.alwaysExecute() && random.nextInt(this.getChance()) != 0) {
            return false;
        }
        return ConditionEvaluator.INSTANCE.check(this.getConditions());
    }

    public abstract void doEffect(@Nonnull IBlockReader var1, @Nonnull BlockState var2, @Nonnull BlockPos var3, @Nonnull Random var4);

    @Nonnull
    public String toString() {
        return "type: " + this.getEffectType().getName() + " conditions: [" + this.getConditions() + ']' + "; chance:" + this.getChance() + ' ' + this.getClass().getSimpleName();
    }
}

