/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.WaterSplashJet;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class WaterfallSplashEffect
extends JetEffect {
    private static final Vector3i[] cardinal_offsets = new Vector3i[]{new Vector3i(-1, 0, 0), new Vector3i(1, 0, 0), new Vector3i(0, 0, -1), new Vector3i(0, 0, 1)};

    public WaterfallSplashEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.SPLASH;
    }

    private static boolean isUnboundedLiquid(IBlockReader provider, BlockPos pos) {
        for (Vector3i cardinal_offset : cardinal_offsets) {
            BlockPos tp = pos.func_177971_a(cardinal_offset);
            BlockState state = provider.func_180495_p(tp);
            if (state.func_185904_a() == Material.field_151579_a) {
                return true;
            }
            FluidState fluidState = state.func_204520_s();
            int height = fluidState.func_206882_g();
            if (height <= 0 || height >= 8) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundedLiquid(IBlockReader provider, BlockPos pos) {
        for (Vector3i cardinal_offset : cardinal_offsets) {
            BlockPos tp = pos.func_177971_a(cardinal_offset);
            BlockState state = provider.func_180495_p(tp);
            if (state.func_185904_a() == Material.field_151579_a) {
                return false;
            }
            FluidState fluidState = state.func_204520_s();
            if (fluidState.func_206888_e()) continue;
            if (((Boolean)fluidState.func_177229_b((Property)FlowingFluid.field_207209_a)).booleanValue()) {
                return false;
            }
            int height = fluidState.func_206882_g();
            if (height <= 0 || height >= 8) continue;
            return false;
        }
        return true;
    }

    private int liquidBlockCount(IBlockReader provider, BlockPos pos) {
        return WaterfallSplashEffect.countVerticalBlocks(provider, pos, FLUID_PREDICATE, 1);
    }

    public static boolean isValidSpawnBlock(@Nonnull IBlockReader provider, @Nonnull BlockPos pos) {
        return WaterfallSplashEffect.isValidSpawnBlock(provider, provider.func_180495_p(pos), pos);
    }

    private static boolean isValidSpawnBlock(IBlockReader provider, BlockState state, BlockPos pos) {
        if (state.func_204520_s().func_206888_e()) {
            return false;
        }
        if (provider.func_204610_c(pos.func_177984_a()).func_206888_e()) {
            return false;
        }
        if (WaterfallSplashEffect.isUnboundedLiquid(provider, pos)) {
            BlockPos down = pos.func_177977_b();
            if (WorldUtils.isBlockSolid(provider, down)) {
                return true;
            }
            return WaterfallSplashEffect.isBoundedLiquid(provider, down);
        }
        return false;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return super.canTrigger(provider, state, pos, random) && WaterfallSplashEffect.isValidSpawnBlock(provider, state, pos);
    }

    @Override
    public void doEffect(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = this.liquidBlockCount(provider, pos);
        if (strength > 1) {
            float height = state.func_204520_s().func_215679_a(provider, pos) + 0.1f;
            WaterSplashJet effect = new WaterSplashJet(strength, provider, pos, (double)height);
            this.addEffect(effect);
        }
    }
}

