/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;

@OnlyIn(value=Dist.CLIENT)
public class BedrockFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected final FogResult cached = new FogResult();
    protected double skyLight;

    public BedrockFogRangeCalculator() {
        super("BedrockFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableBedrockFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        this.cached.set(event);
        if (!CommonState.getDimensionInfo().isFlatWorld() && WorldUtils.hasVoidParticles((World)GameUtils.getWorld())) {
            PlayerEntity player = GameUtils.getPlayer();
            double factor = (MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)player.field_70137_T, (double)player.func_226278_cu_()) + 4.0) / 32.0;
            double d0 = this.skyLight / 16.0 + factor;
            float end = event.getFarPlaneDistance();
            if (d0 < 1.0) {
                float f2;
                if (d0 < 0.0) {
                    d0 = 0.0;
                }
                if ((f2 = 100.0f * (float)(d0 *= d0)) < 5.0f) {
                    f2 = 5.0f;
                }
                if (end > f2) {
                    end = f2;
                }
            }
            this.cached.setScaled(end, 0.75f);
        }
        return this.cached;
    }

    @Override
    public void tick() {
        this.skyLight = GameUtils.getPlayer().func_70013_c();
    }
}

