/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.library.BiomeInfo;
import org.orecruncher.environs.library.BiomeLibrary;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.lib.DayCycle;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.MinecraftClock;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.seasons.Season;

@OnlyIn(value=Dist.CLIENT)
public final class CommonState {
    private static CommonState instance = new CommonState();
    Season season = Season.NONE;
    BiomeInfo playerBiome = BiomeLibrary.WTF_INFO;
    BiomeInfo truePlayerBiome = BiomeLibrary.WTF_INFO;
    int dimensionId;
    String dimensionName = "";
    DimensionInfo dimInfo = DimensionInfo.NONE;
    BlockPos playerPosition = BlockPos.field_177992_a;
    Vector3d playerEyePosition = Vector3d.field_186680_a;
    float biomeTemperature = 0.0f;
    boolean inside;
    boolean isUnderground;
    boolean isInSpace;
    boolean isInClouds;
    boolean isInVillage;
    int lightLevel;
    DayCycle dayCycle = DayCycle.NO_SKY;
    MinecraftClock clock = new MinecraftClock();

    static CommonState getData() {
        return instance;
    }

    static void reset() {
        instance = new CommonState();
    }

    CommonState() {
    }

    public static Season getSeason() {
        return CommonState.instance.season;
    }

    public static BiomeInfo getPlayerBiome() {
        return CommonState.instance.playerBiome;
    }

    public static BiomeInfo getTruePlayerBiome() {
        return CommonState.instance.truePlayerBiome;
    }

    public static int getDimensionId() {
        return CommonState.instance.dimensionId;
    }

    public static String getDimensioName() {
        return CommonState.instance.dimensionName;
    }

    public static DimensionInfo getDimensionInfo() {
        return CommonState.instance.dimInfo;
    }

    public static BlockPos getPlayerPosition() {
        return CommonState.instance.playerPosition;
    }

    public static Vector3d getPlayerEyePosition() {
        return CommonState.instance.playerEyePosition;
    }

    public static float getCurrentTemperature() {
        return CommonState.instance.biomeTemperature;
    }

    public static boolean isInside() {
        return CommonState.instance.inside;
    }

    public static boolean isUnderground() {
        return CommonState.instance.isUnderground;
    }

    public static boolean isInClouds() {
        return CommonState.instance.isInClouds;
    }

    public static boolean isInSpace() {
        return CommonState.instance.isInSpace;
    }

    public static boolean isInVillage() {
        return CommonState.instance.isInVillage;
    }

    public static int getLightLevel() {
        return CommonState.instance.lightLevel;
    }

    public static long getTick() {
        return TickCounter.getTickCount();
    }

    public static DayCycle getDayCycle() {
        return CommonState.instance.dayCycle;
    }

    public static MinecraftClock getClock() {
        return CommonState.instance.clock;
    }

    public static IWorldReader getBlockReader() {
        return GameUtils.getWorld();
    }
}

